/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.RowBandAction;
import org.eclipse.birt.report.model.api.RowBandAdapter;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.RowOperationParameters;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.elements.SemanticError;

class RowBandCopyAction
extends RowBandAction {
    RowBandCopyAction(RowBandAdapter adapter) {
        super(adapter);
    }

    protected boolean canCopy(RowOperationParameters parameters) {
        int destIndex = parameters.getDestIndex();
        SlotHandle slotHandle = this.getSlotHandle(parameters);
        if (slotHandle == null || slotHandle.getCount() == 0 || destIndex < 0 || destIndex >= slotHandle.getCount()) {
            return false;
        }
        RowHandle rowHandle = (RowHandle)slotHandle.get(destIndex);
        return !this.containsRowSpan(rowHandle) && this.isRectangleArea(rowHandle);
    }

    protected IDesignElement doCopy(RowOperationParameters parameters) throws SemanticException {
        if (!this.canCopy(parameters)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{this.adapter.getElementHandle().getName()}, "Error.SemanticError.ROW_COPY_FORBIDDEN");
        }
        int destIndex = parameters.getDestIndex();
        SlotHandle slotHandle = this.getSlotHandle(parameters);
        RowHandle rowHandle = (RowHandle)slotHandle.get(destIndex);
        return this.copyRow(rowHandle);
    }
}

