/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.command.CssCommand;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.ReportDesign;

public class CssStyleSheetHandleAdapter {
    private final Module module;
    private final DesignElement element;

    public CssStyleSheetHandleAdapter(Module module, DesignElement element) {
        this.module = module;
        this.element = element;
    }

    public final void addCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        URL url;
        if (sheetHandle == null) {
            return;
        }
        if (sheetHandle.getFileName() != null && (url = this.module.findResource(sheetHandle.getFileName(), 3)) == null) {
            throw new CssException(this.module, new String[]{sheetHandle.getFileName()}, "Error.CSSException.CSS_NOT_FOUND");
        }
        if (!this.canAddCssStyleSheet(sheetHandle)) {
            throw new CssException(this.module, new String[]{sheetHandle.getFileName()}, "Error.CSSException.DUPLICATE_CSS");
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.addCss(sheetHandle.getStyleSheet());
    }

    public final void addCssbyProperties(String fileName, String externalCssURI, boolean isUseExternalCss) throws SemanticException {
        URL url;
        if (fileName != null && (url = this.module.findResource(fileName, 3)) == null) {
            throw new CssException(this.module, new String[]{fileName}, "Error.CSSException.CSS_NOT_FOUND");
        }
        if (!this.canAddCssStyleSheetByProperties(fileName, externalCssURI, isUseExternalCss)) {
            throw new CssException(this.module, new String[]{fileName}, "Error.CSSException.DUPLICATE_CSS");
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.addCssByProperties(fileName, externalCssURI, isUseExternalCss);
    }

    @Deprecated
    public final void addCss(String fileName) throws SemanticException {
        if (fileName == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.addCss(fileName);
    }

    public final void dropCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        if (sheetHandle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.dropCss(sheetHandle.getStyleSheet());
    }

    public final boolean canDropCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        if (!this.element.canEdit(this.module) || sheetHandle == null) {
            return false;
        }
        int position = CssStyleSheetAdapter.getPositionOfCssStyleSheetByProperties(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), sheetHandle.getFileName(), sheetHandle.getExternalCssURI(), sheetHandle.isUseExternalCss());
        return position != -1;
    }

    @Deprecated
    public final boolean canAddCssStyleSheet(String fileName) {
        if (!this.element.canEdit(this.module) || fileName == null) {
            return false;
        }
        URL url = this.module.findResource(fileName, 3);
        if (url == null) {
            return false;
        }
        CssStyleSheet sheet = CssStyleSheetAdapter.getCssStyleSheetByLocation(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), url);
        return sheet == null;
    }

    public final boolean canAddCssStyleSheetByProperties(String fileName, String externalCssURI, boolean isUseExternalCss) {
        CssStyleSheet sheet;
        if (!this.element.canEdit(this.module)) {
            return false;
        }
        URL url = null;
        if (fileName != null) {
            url = this.module.findResource(fileName, 3);
        }
        if ((sheet = CssStyleSheetAdapter.getCssStyleSheetByProperties(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), url, externalCssURI, isUseExternalCss)) != null) {
            return false;
        }
        sheet = CssStyleSheetAdapter.getCssStyleSheetByLocation(this.module, ((ICssStyleSheetOperation)((Object)this.element)).getCsses(), url);
        return sheet == null;
    }

    public final boolean canAddCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        if (!this.element.canEdit(this.module) || sheetHandle == null) {
            return false;
        }
        return this.canAddCssStyleSheetByProperties(sheetHandle.getFileName(), sheetHandle.getExternalCssURI(), sheetHandle.isUseExternalCss());
    }

    public final void reloadCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        if (sheetHandle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.reloadCss(sheetHandle.getStyleSheet());
    }

    public final void addCss(IncludedCssStyleSheet cssStruct) throws SemanticException {
        URL url;
        if (cssStruct == null) {
            return;
        }
        if (cssStruct.getFileName() != null && (url = this.module.findResource(cssStruct.getFileName(), 3)) == null) {
            throw new CssException(this.module, new String[]{cssStruct.getFileName()}, "Error.CSSException.CSS_NOT_FOUND");
        }
        if (!this.canAddCssStyleSheetByProperties(cssStruct.getFileName(), cssStruct.getExternalCssURI(), cssStruct.isUseExternalCss())) {
            throw new CssException(this.module, new String[]{cssStruct.getFileName()}, "Error.CSSException.DUPLICATE_CSS");
        }
        CssCommand command = new CssCommand(this.module, this.element);
        command.addCss(cssStruct);
    }

    @Deprecated
    public IncludedCssStyleSheetHandle findIncludedCssStyleSheetHandleByFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        String propName = null;
        if (this.element instanceof ReportDesign) {
            propName = "cssStyleSheets";
        } else if (this.element instanceof AbstractTheme) {
            propName = "cssStyleSheets";
        }
        assert (propName != null);
        PropertyHandle propHandle = this.element.getHandle(this.module).getPropertyHandle(propName);
        Iterator handleIter = propHandle.iterator();
        while (handleIter.hasNext()) {
            IncludedCssStyleSheetHandle handle = (IncludedCssStyleSheetHandle)handleIter.next();
            if (!fileName.equals(handle.getFileName())) continue;
            return handle;
        }
        return null;
    }

    public IncludedCssStyleSheetHandle findIncludedCssStyleSheetHandleByProperties(String fileName, String externalCssURI, boolean useExternalCss) {
        String propName = null;
        if (this.element instanceof ReportDesign) {
            propName = "cssStyleSheets";
        } else if (this.element instanceof AbstractTheme) {
            propName = "cssStyleSheets";
        }
        assert (propName != null);
        PropertyHandle propHandle = this.element.getHandle(this.module).getPropertyHandle(propName);
        Iterator handleIter = propHandle.iterator();
        while (handleIter.hasNext()) {
            IncludedCssStyleSheetHandle handle = (IncludedCssStyleSheetHandle)handleIter.next();
            if (!this.equals(fileName, externalCssURI, useExternalCss, handle)) continue;
            return handle;
        }
        return null;
    }

    private boolean equals(String fileName, String externalCssURI, boolean useExternalCss, IncludedCssStyleSheetHandle handle) {
        String name = handle.getFileName();
        String uri = handle.getExternalCssURI();
        boolean useCss = handle.isUseExternalCss();
        return (fileName == null && name == null || fileName != null && fileName.equals(name)) && (externalCssURI == null && uri == null || externalCssURI != null && externalCssURI.equals(uri)) && useExternalCss == useCss;
    }

    @Deprecated
    public CssStyleSheetHandle findCssStyleSheetHandleByFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        List<CssStyleSheet> list = ((ICssStyleSheetOperation)((Object)this.element)).getCsses();
        int i = 0;
        while (i < list.size()) {
            CssStyleSheet css = list.get(i);
            if (fileName.equals(css.getFileName())) {
                return css.handle(this.module);
            }
            ++i;
        }
        return null;
    }

    public CssStyleSheetHandle findCssStyleSheetHandleByProperties(String fileName, String externalCssURI, boolean useExternalCss) {
        if (fileName != null) {
            List<CssStyleSheet> list = ((ICssStyleSheetOperation)((Object)this.element)).getCsses();
            int i = 0;
            while (i < list.size()) {
                CssStyleSheet css = list.get(i);
                String name = css.getFileName();
                String uri = css.getExternalCssURI();
                boolean useCss = css.isUseExternalCss();
                if ((fileName == null && name == null || fileName != null && fileName.equals(name)) && (externalCssURI == null && uri == null || externalCssURI != null && externalCssURI.equals(uri)) && useExternalCss == useCss) {
                    return css.handle(this.module);
                }
                ++i;
            }
        }
        return null;
    }

    @Deprecated
    public void renameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        if (newFileName == null || handle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        IncludedCssStyleSheet includedCssStyleSheet = command.getIncludedCssStyleSheetByLocation(handle.getFileName());
        command.renameCss(includedCssStyleSheet, newFileName);
    }

    public void renameCssByProperties(IncludedCssStyleSheetHandle handle, String fileName, String externalCssURI, boolean isUseExternalCss) throws SemanticException {
        if (handle == null) {
            return;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        IncludedCssStyleSheet includedCssStyleSheet = command.getIncludedCssStyleSheetByProperties(handle.getFileName(), handle.getExternalCssURI(), handle.isUseExternalCss());
        command.renameCssByProperties(includedCssStyleSheet, fileName, externalCssURI, isUseExternalCss);
    }

    @Deprecated
    public boolean canRenameCss(IncludedCssStyleSheetHandle sheetHandle, String newFileName) {
        if (newFileName == null || sheetHandle == null || sheetHandle.getFileName().equals(newFileName)) {
            return false;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        IncludedCssStyleSheet includedCssStyleSheet = command.getIncludedCssStyleSheetByLocation(sheetHandle.getFileName());
        IncludedCssStyleSheet foundIncludedCssStyleSheet = null;
        try {
            foundIncludedCssStyleSheet = command.checkRenameCss(includedCssStyleSheet, newFileName);
        }
        catch (CssException e) {
            return false;
        }
        return foundIncludedCssStyleSheet != sheetHandle.getStructure();
    }

    public boolean canRenameCssByProperties(IncludedCssStyleSheetHandle sheetHandle, String newFileName, String externalCssURI, boolean isUseExternalCss) {
        if (sheetHandle == null) {
            return false;
        }
        CssCommand command = new CssCommand(this.module, this.element);
        IncludedCssStyleSheet includedCssStyleSheet = command.getIncludedCssStyleSheetByProperties(sheetHandle.getFileName(), sheetHandle.getExternalCssURI(), sheetHandle.isUseExternalCss());
        IncludedCssStyleSheet foundIncludedCssStyleSheet = null;
        try {
            foundIncludedCssStyleSheet = command.checkRenameCssByProperties(includedCssStyleSheet, newFileName, externalCssURI, isUseExternalCss);
        }
        catch (CssException e) {
            return false;
        }
        return foundIncludedCssStyleSheet != sheetHandle.getStructure();
    }
}

