/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.SerializerTypeInferer;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HCounterColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class HCounterColumnImpl<N>
implements HCounterColumn<N> {
    private CounterColumn counterColumn;
    private Serializer<N> nameSerializer;

    public HCounterColumnImpl(N name, Long value, Serializer<N> nameSerializer) {
        this(nameSerializer);
        Assert.notNull(name, "name is null");
        Assert.notNull(value, "value is null");
        this.counterColumn = new CounterColumn(nameSerializer.toByteBuffer(name), value.longValue());
    }

    public HCounterColumnImpl(CounterColumn thriftCounterColumn, Serializer<N> nameSerializer) {
        this(nameSerializer);
        Assert.notNull(thriftCounterColumn, "thriftColumn is null");
        this.counterColumn = thriftCounterColumn;
    }

    public HCounterColumnImpl(Serializer<N> nameSerializer) {
        Assert.notNull(nameSerializer, "nameSerializer is null");
        this.nameSerializer = nameSerializer;
        this.counterColumn = new CounterColumn();
    }

    public HCounterColumnImpl(N name, Long value) {
        this(name, value, SerializerTypeInferer.getSerializer(name));
    }

    @Override
    public HCounterColumn<N> setName(N name) {
        Assert.notNull(name, "name is null");
        this.counterColumn.setName(this.nameSerializer.toByteBuffer(name));
        return this;
    }

    @Override
    public HCounterColumn<N> setValue(Long value) {
        Assert.notNull(value, "value is null");
        this.counterColumn.setValue(value.longValue());
        return this;
    }

    @Override
    public HCounterColumn<N> setTtl(int ttl) {
        return this;
    }

    @Override
    public int getTtl() {
        return Integer.MAX_VALUE;
    }

    @Override
    public N getName() {
        return this.counterColumn.isSetName() ? (N)this.nameSerializer.fromByteBuffer(this.counterColumn.name.duplicate()) : null;
    }

    @Override
    public Long getValue() {
        return this.counterColumn.value;
    }

    public CounterColumn toThrift() {
        return this.counterColumn;
    }

    public HCounterColumn<N> fromThrift(CounterColumn c) {
        Assert.notNull(c, "column is null");
        this.counterColumn = c;
        return this;
    }

    @Override
    public Serializer<N> getNameSerializer() {
        return this.nameSerializer;
    }

    @Override
    public ByteBuffer getNameBytes() {
        return this.counterColumn.isSetName() ? this.counterColumn.name.duplicate() : null;
    }

    @Override
    public HCounterColumn<N> clear() {
        this.counterColumn.value = 0L;
        this.counterColumn.setValueIsSet(false);
        return this;
    }

    @Override
    public HCounterColumn<N> apply(Long value, int ttl) {
        this.setValue(value);
        return this;
    }

    public HCounterColumn<N> apply(CounterColumn c) {
        this.counterColumn = c;
        return this;
    }

    public String toString() {
        return String.format("HCounterColumn(%s=%s)", this.getName(), this.getValue());
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getName()).append((Object)this.getValue()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HCounterColumnImpl other = (HCounterColumnImpl)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.getName(), other.getName()).append((Object)this.getValue(), (Object)other.getValue()).isEquals();
    }
}

