/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.List;
import me.prettyprint.cassandra.model.ColumnSliceImpl;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.Row;
import org.apache.cassandra.thrift.Column;

public final class RowImpl<K, N, V>
implements Row<K, N, V> {
    private final K rowKey;
    private final ColumnSlice<N, V> columnSlice;

    RowImpl(K k, List<Column> columns, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        Assert.noneNull(k, columns, nameSerializer, valueSerializer);
        this.rowKey = k;
        this.columnSlice = new ColumnSliceImpl<N, V>(columns, nameSerializer, valueSerializer);
    }

    @Override
    public K getKey() {
        return this.rowKey;
    }

    @Override
    public ColumnSlice<N, V> getColumnSlice() {
        return this.columnSlice;
    }

    public String toString() {
        return "Row(" + this.rowKey + "," + this.columnSlice + ")";
    }
}

