/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ExceptionsTranslator;
import me.prettyprint.cassandra.service.ExceptionsTranslatorImpl;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.JmxMonitor;
import me.prettyprint.cassandra.service.Operation;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.cassandra.service.ThriftKsDef;
import me.prettyprint.hector.api.ClockResolution;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCluster
implements Cluster {
    private static final Map<String, String> EMPTY_CREDENTIALS = Collections.emptyMap();
    private final Logger log = LoggerFactory.getLogger(AbstractCluster.class);
    public static final int RING_DELAY = 30000;
    public static final int WAIT_FOR_SCHEMA_AGREEMENT_SLEEP_TIME = 1000;
    protected final HConnectionManager connectionManager;
    private final String name;
    private final CassandraHostConfigurator configurator;
    private final ClockResolution clockResolution;
    private final FailoverPolicy failoverPolicy;
    private final CassandraClientMonitor cassandraClientMonitor;
    private Set<CassandraHost> knownPoolHosts;
    protected final ExceptionsTranslator xtrans;
    private final Map<String, String> credentials;

    public AbstractCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator) {
        this(clusterName, cassandraHostConfigurator, EMPTY_CREDENTIALS);
    }

    public AbstractCluster(String clusterName, CassandraHostConfigurator cassandraHostConfigurator, Map<String, String> credentials) {
        this.connectionManager = new HConnectionManager(clusterName, cassandraHostConfigurator);
        this.name = clusterName;
        this.configurator = cassandraHostConfigurator;
        this.failoverPolicy = FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE;
        this.cassandraClientMonitor = JmxMonitor.getInstance().getCassandraMonitor(this.connectionManager);
        this.xtrans = new ExceptionsTranslatorImpl();
        this.clockResolution = cassandraHostConfigurator.getClockResolution();
        this.credentials = Collections.unmodifiableMap(credentials == null ? EMPTY_CREDENTIALS : credentials);
    }

    @Override
    public HConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public Set<CassandraHost> getKnownPoolHosts(boolean refresh) {
        if (refresh || this.knownPoolHosts == null) {
            this.knownPoolHosts = this.connectionManager.getHosts();
            if (this.log.isInfoEnabled()) {
                this.log.info("found knownPoolHosts: {}", this.knownPoolHosts);
            }
        }
        return this.knownPoolHosts;
    }

    @Override
    public void addHost(CassandraHost cassandraHost, boolean skipApplyConfig) {
        if (!skipApplyConfig && this.configurator != null) {
            this.configurator.applyConfig(cassandraHost);
        }
        this.connectionManager.addCassandraHost(cassandraHost);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<KeyspaceDefinition> describeKeyspaces() throws HectorException {
        Operation<List<KeyspaceDefinition>> op = new Operation<List<KeyspaceDefinition>>(OperationType.META_READ, this.getCredentials()){

            @Override
            public List<KeyspaceDefinition> execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return ThriftKsDef.fromThriftList(cassandra.describe_keyspaces());
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (List)op.getResult();
    }

    @Override
    public String describeClusterName() throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_READ, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.describe_cluster_name();
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String describeThriftVersion() throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_READ, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return cassandra.describe_version();
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public KeyspaceDefinition describeKeyspace(final String keyspace) throws HectorException {
        Operation<KeyspaceDefinition> op = new Operation<KeyspaceDefinition>(OperationType.META_READ, this.getCredentials()){

            @Override
            public KeyspaceDefinition execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    return new ThriftKsDef(cassandra.describe_keyspace(keyspace));
                }
                catch (NotFoundException nfe) {
                    this.setException(AbstractCluster.this.xtrans.translate(nfe));
                    return null;
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (KeyspaceDefinition)op.getResult();
    }

    @Override
    public String getClusterName() throws HectorException {
        return this.describeClusterName();
    }

    @Override
    public String dropKeyspace(String keyspace) throws HectorException {
        return this.dropKeyspace(keyspace, false);
    }

    @Override
    public String dropKeyspace(final String keyspace, final boolean waitForSchemaAgreement) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, FailoverPolicy.FAIL_FAST, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    String schemaId = cassandra.system_drop_keyspace(keyspace);
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    return schemaId;
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String describePartitioner() throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_READ, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    if (AbstractCluster.this.log.isInfoEnabled()) {
                        AbstractCluster.this.log.info("in execute with client {}", (Object)cassandra);
                    }
                    return cassandra.describe_partitioner();
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public String dropColumnFamily(String keyspaceName, String columnFamily) throws HectorException {
        return this.dropColumnFamily(keyspaceName, columnFamily, false);
    }

    @Override
    public String dropColumnFamily(String keyspaceName, final String columnFamily, final boolean waitForSchemaAgreement) throws HectorException {
        Operation<String> op = new Operation<String>(OperationType.META_WRITE, FailoverPolicy.FAIL_FAST, keyspaceName, this.getCredentials()){

            @Override
            public String execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    String schemaId = cassandra.system_drop_column_family(columnFamily);
                    if (waitForSchemaAgreement) {
                        AbstractCluster.waitForSchemaAgreement(cassandra);
                    }
                    return schemaId;
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
            }
        };
        this.connectionManager.operateWithFailover(op);
        return (String)op.getResult();
    }

    @Override
    public Map<String, String> getCredentials() {
        return this.credentials;
    }

    @Override
    public void truncate(String keyspaceName, final String columnFamily) throws HectorException {
        Operation<Void> op = new Operation<Void>(OperationType.META_WRITE, FailoverPolicy.FAIL_FAST, keyspaceName, this.getCredentials()){

            @Override
            public Void execute(Cassandra.Client cassandra) throws HectorException {
                try {
                    cassandra.truncate(columnFamily);
                }
                catch (Exception e) {
                    throw AbstractCluster.this.xtrans.translate(e);
                }
                return null;
            }
        };
        this.connectionManager.operateWithFailover(op);
    }

    @Override
    public void onStartup() {
    }

    public CassandraHostConfigurator getConfigurator() {
        return this.configurator;
    }

    protected static void waitForSchemaAgreement(Cassandra.Client cassandra) throws InvalidRequestException, TException, InterruptedException {
        int waited = 0;
        int versions = 0;
        while (versions != 1) {
            versions = 0;
            Map schema = cassandra.describe_schema_versions();
            for (Map.Entry entry : schema.entrySet()) {
                if (((String)entry.getKey()).equals("UNREACHABLE")) continue;
                ++versions;
            }
            if (versions == true) continue;
            Thread.sleep(1000L);
            if ((waited += 1000) <= 30000) continue;
            throw new RuntimeException("Could not reach schema agreement in 30000ms");
        }
    }
}

