/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;

public class CachedBundles {
    private Map<String, LocaleResourceBundle> bundles;

    CachedBundles() {
    }

    String getMessage(String fileName, String resourceKey) {
        if (this.bundles == null) {
            return null;
        }
        LocaleResourceBundle tmpBundle = this.bundles.get(fileName);
        if (tmpBundle == null) {
            return null;
        }
        return tmpBundle.getMessage(resourceKey);
    }

    Set<String> getMessageKeys(String fileName) {
        if (this.bundles == null) {
            return null;
        }
        LocaleResourceBundle tmpBundle = this.bundles.get(fileName);
        if (tmpBundle == null) {
            return null;
        }
        return tmpBundle.getMessageKeys();
    }

    boolean isCached(String fileName) {
        if (this.bundles == null) {
            return false;
        }
        return this.bundles.containsKey(fileName);
    }

    void addCachedBundle(String fileName, URL bundleURL) {
        assert (fileName != null);
        if (this.bundles == null) {
            this.bundles = new HashMap<String, LocaleResourceBundle>(6);
        }
        if (bundleURL == null) {
            this.bundles.put(fileName, new LocaleResourceBundle(null));
        } else {
            this.bundles.put(fileName, new LocaleResourceBundle(CachedBundles.populateBundle(bundleURL)));
        }
    }

    public static PropertyResourceBundle populateBundle(URL bundleURL) {
        InputStream is = null;
        try {
            if (bundleURL == null) {
                return null;
            }
            is = bundleURL.openStream();
            PropertyResourceBundle bundle = new PropertyResourceBundle(is);
            is.close();
            is = null;
            PropertyResourceBundle propertyResourceBundle = bundle;
            return propertyResourceBundle;
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    is = null;
                }
            }
        }
        return null;
    }

    private static class LocaleResourceBundle {
        private PropertyResourceBundle bundle;

        LocaleResourceBundle(PropertyResourceBundle bundle) {
            this.bundle = bundle;
        }

        private String getMessage(String resourceKey) {
            if (this.bundle == null) {
                return null;
            }
            String translation = (String)this.bundle.handleGetObject(resourceKey);
            return translation;
        }

        private Set<String> getMessageKeys() {
            if (this.bundle == null) {
                return Collections.emptySet();
            }
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            Enumeration<String> enumeration = this.bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                keys.add(enumeration.nextElement());
            }
            return keys;
        }
    }
}

