/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility.filename;

import java.util.Map;
import org.eclipse.birt.report.utility.filename.IFilenameGenerator;

public class DefaultFilenameGenerator
implements IFilenameGenerator {
    public static final String DEFAULT_FILENAME = "BIRTReport";

    @Override
    public String getFilename(String baseName, String extension, String outputType, Map options) {
        return DefaultFilenameGenerator.makeFileName(baseName, extension);
    }

    public static String makeFileName(String fileName, String extensionName) {
        String baseName = fileName;
        if (baseName == null || baseName.trim().length() <= 0) {
            baseName = DEFAULT_FILENAME;
        }
        int i = 0;
        while (i < baseName.length()) {
            char c = baseName.charAt(i);
            if (c < '\u0000' || c >= '\u0080') {
                baseName = DEFAULT_FILENAME;
                break;
            }
            ++i;
        }
        if (extensionName != null && extensionName.length() > 0) {
            baseName = String.valueOf(baseName) + "." + extensionName;
        }
        return baseName;
    }
}

