/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.script.internal.handler;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.script.internal.CrosstabCellInstanceImpl;
import org.eclipse.birt.report.item.crosstab.core.script.internal.CrosstabInstanceImpl;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.BaseCrosstabEventHandler;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.CrosstabScriptHandler;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class CrosstabCreationHandler
extends BaseCrosstabEventHandler {
    private CrosstabScriptHandler handler;

    public CrosstabCreationHandler(ExtendedItemHandle modelHandle, ClassLoader contextLoader) throws BirtException {
        String javaClass = modelHandle.getEventHandlerClass();
        String script = modelHandle.getOnCreate();
        if (!(javaClass != null && javaClass.trim().length() != 0 || script != null && script.trim().length() != 0)) {
            return;
        }
        this.handler = this.createScriptHandler((DesignElementHandle)modelHandle, "onCreate", script, contextLoader);
    }

    public void handleCrosstab(CrosstabReportItemHandle crosstab, ITableContent content, IReportContext context, RunningState runningState) throws BirtException {
        if (this.handler == null || crosstab == null) {
            return;
        }
        CrosstabInstanceImpl crosstabInst = new CrosstabInstanceImpl(content, crosstab.getModelHandle(), runningState);
        this.handler.callFunction("onCreateCrosstab", crosstabInst, context);
    }

    public void handleCell(CrosstabCellHandle cell, ICellContent content, IReportContext context) throws BirtException {
        if (this.handler == null || cell == null) {
            return;
        }
        CrosstabCellInstanceImpl cellInst = new CrosstabCellInstanceImpl(content, (ExtendedItemHandle)cell.getModelHandle(), context);
        this.handler.callFunction("onCreateCell", cellInst, context);
    }
}

