/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene101;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene101.Lucene101PostingsReader;
import org.apache.lucene.codecs.lucene101.Lucene101PostingsWriter;
import org.apache.lucene.codecs.lucene90.blocktree.Lucene90BlockTreeTermsReader;
import org.apache.lucene.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.util.IOUtils;

public final class Lucene101PostingsFormat
extends PostingsFormat {
    public static final String META_EXTENSION = "psm";
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    public static final int BLOCK_SIZE = 128;
    public static final int BLOCK_MASK = 127;
    public static final int LEVEL1_FACTOR = 32;
    public static final int LEVEL1_NUM_DOCS = 4096;
    public static final int LEVEL1_MASK = 4095;
    static final String TERMS_CODEC = "Lucene90PostingsWriterTerms";
    static final String META_CODEC = "Lucene101PostingsWriterMeta";
    static final String DOC_CODEC = "Lucene101PostingsWriterDoc";
    static final String POS_CODEC = "Lucene101PostingsWriterPos";
    static final String PAY_CODEC = "Lucene101PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    private final int minTermBlockSize;
    private final int maxTermBlockSize;

    public Lucene101PostingsFormat() {
        this(25, 48);
    }

    public Lucene101PostingsFormat(int minTermBlockSize, int maxTermBlockSize) {
        super("Lucene101");
        Lucene90BlockTreeTermsWriter.validateSettings(minTermBlockSize, maxTermBlockSize);
        this.minTermBlockSize = minTermBlockSize;
        this.maxTermBlockSize = maxTermBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        Lucene90BlockTreeTermsWriter lucene90BlockTreeTermsWriter;
        block3: {
            Lucene101PostingsWriter postingsWriter = new Lucene101PostingsWriter(state);
            boolean success = false;
            try {
                Lucene90BlockTreeTermsWriter ret = new Lucene90BlockTreeTermsWriter(state, postingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
                success = true;
                lucene90BlockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return lucene90BlockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        Lucene90BlockTreeTermsReader lucene90BlockTreeTermsReader;
        block3: {
            Lucene101PostingsReader postingsReader = new Lucene101PostingsReader(state);
            boolean success = false;
            try {
                Lucene90BlockTreeTermsReader ret = new Lucene90BlockTreeTermsReader(postingsReader, state);
                success = true;
                lucene90BlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return lucene90BlockTreeTermsReader;
    }

    public static final class IntBlockTermState
    extends BlockTermState {
        public long docStartFP;
        public long posStartFP;
        public long payStartFP;
        public long lastPosBlockOffset = -1L;
        public int singletonDocID = -1;

        @Override
        public IntBlockTermState clone() {
            IntBlockTermState other = new IntBlockTermState();
            other.copyFrom(this);
            return other;
        }

        @Override
        public void copyFrom(TermState _other) {
            super.copyFrom(_other);
            IntBlockTermState other = (IntBlockTermState)_other;
            this.docStartFP = other.docStartFP;
            this.posStartFP = other.posStartFP;
            this.payStartFP = other.payStartFP;
            this.lastPosBlockOffset = other.lastPosBlockOffset;
            this.singletonDocID = other.singletonDocID;
        }

        @Override
        public String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

