/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.birt.report.designer.ui.IDatasetWorkspaceClasspathFinder;
import org.eclipse.birt.report.designer.ui.IReportClasspathResolver;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class DatasetClassPathHelper {
    public static final String WORKSPACE_CLASSPATH_KEY = "workspace.projectclasspath";
    private static final String FINDER_BUNDLE_NAME = "org.eclipse.birt.report.debug.ui";
    private static final String FINDER_CLASSNAME = "org.eclipse.birt.report.debug.internal.ui.launcher.util.WorkspaceClassPathFinder";
    protected static boolean inDevelopmentMode = false;
    protected static String[] devDefaultClasspath;
    protected static Properties devProperties;
    public static final String PROPERTYSEPARATOR;

    static {
        devProperties = null;
        PROPERTYSEPARATOR = File.pathSeparator;
        String osgiDev = System.getProperty("osgi.dev");
        if (osgiDev != null) {
            try {
                inDevelopmentMode = true;
                URL location = new URL(osgiDev);
                devProperties = DatasetClassPathHelper.load(location);
                if (devProperties != null) {
                    devDefaultClasspath = DatasetClassPathHelper.getArrayFromList(devProperties.getProperty("*"));
                }
            }
            catch (MalformedURLException e) {
                devDefaultClasspath = DatasetClassPathHelper.getArrayFromList(osgiDev);
            }
        }
    }

    private static String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    public static boolean inDevelopmentMode() {
        return inDevelopmentMode;
    }

    private static Properties load(URL url) {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = url.openStream();){
                props.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    @Deprecated
    public static String getWorkspaceClassPath() {
        IDatasetWorkspaceClasspathFinder finder;
        block6: {
            Bundle bundle;
            block5: {
                try {
                    bundle = Platform.getBundle((String)FINDER_BUNDLE_NAME);
                    if (bundle != null && bundle.getState() == 4) {
                        bundle.start(1);
                    }
                    if (bundle != null) break block5;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            Class clz = bundle.loadClass(FINDER_CLASSNAME);
            finder = (IDatasetWorkspaceClasspathFinder)clz.newInstance();
            if (finder != null) break block6;
            return null;
        }
        return finder.getClassPath();
    }

    public static List<URL> getWorkspaceClassPath(String reportFilePath) {
        String[] classpaths;
        ArrayList<URL> urls = new ArrayList<URL>();
        IReportClasspathResolver provider = ReportPlugin.getDefault().getReportClasspathResolverService();
        if (provider != null && (classpaths = provider.resolveClasspath(reportFilePath)) != null && classpaths.length != 0) {
            int j = 0;
            while (j < classpaths.length) {
                File file = new File(classpaths[j]);
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ++j;
            }
        }
        return urls;
    }
}

