/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.wizards.XSDNewFilePage;

public class NewXSDWizard
extends Wizard
implements INewWizard {
    private XSDNewFilePage newFilePage;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    static /* synthetic */ Class class$0;

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this.selection = aSelection;
        this.workbench = aWorkbench;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile((Class)clazz, (String)"icons/NewXSD.png"));
        this.setWindowTitle(XSDEditorPlugin.getXSDString("_UI_WIZARD_CREATE_XSD_MODEL_TITLE"));
    }

    public void addPages() {
        this.newFilePage = new XSDNewFilePage(this.selection);
        this.addPage((IWizardPage)this.newFilePage);
    }

    public boolean performFinish() {
        Preferences preference;
        String charSet;
        IFile file = this.newFilePage.createNewFile();
        IPath iPath = file.getFullPath().removeFileExtension();
        String schemaName = iPath.lastSegment();
        String schemaPrefix = "tns";
        String prefixForSchemaNamespace = "";
        String schemaNamespaceAttribute = "xmlns";
        if (XSDEditorPlugin.getPlugin().isQualifyXMLSchemaLanguage() && XSDEditorPlugin.getPlugin().getXMLSchemaPrefix().trim().length() > 0) {
            prefixForSchemaNamespace = String.valueOf(XSDEditorPlugin.getPlugin().getXMLSchemaPrefix()) + ":";
            schemaNamespaceAttribute = String.valueOf(schemaNamespaceAttribute) + ":" + XSDEditorPlugin.getPlugin().getXMLSchemaPrefix();
        }
        if ((charSet = (preference = XMLCorePlugin.getDefault().getPluginPreferences()).getString("outputCodeset")) == null || charSet.trim().equals("")) {
            charSet = "UTF-8";
        }
        String newContents = "<?xml version=\"1.0\" encoding=\"" + charSet + "\"?>\n";
        String defaultTargetURI = XSDEditorPlugin.getPlugin().getXMLSchemaTargetNamespace();
        newContents = String.valueOf(newContents) + "<" + prefixForSchemaNamespace + "schema " + schemaNamespaceAttribute + "=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"" + defaultTargetURI + schemaName + "\" xmlns:" + schemaPrefix + "=\"" + defaultTargetURI + schemaName + "\" elementFormDefault=\"qualified\">\n</" + prefixForSchemaNamespace + "schema>";
        try {
            byte[] bytes = newContents.getBytes(charSet);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            file.setContents((InputStream)inputStream, true, false, null);
            inputStream.close();
        }
        catch (Exception exception) {}
        if (file != null) {
            this.revealSelection((ISelection)new StructuredSelection((Object)file));
        }
        this.openEditor(file);
        return true;
    }

    private void revealSelection(final ISelection selection) {
        IWorkbench workbench2;
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPart focusPart;
        if (selection != null && (focusPart = (workbenchWindow = (workbench2 = this.workbench == null ? XSDEditorPlugin.getPlugin().getWorkbench() : this.workbench).getActiveWorkbenchWindow()).getActivePage().getActivePart()) instanceof ISetSelectionTarget) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ((ISetSelectionTarget)focusPart).selectReveal(selection);
                }
            });
        }
    }

    public void openEditor(final IFile iFile) {
        if (iFile != null) {
            IWorkbench workbench2 = this.workbench == null ? XSDEditorPlugin.getPlugin().getWorkbench() : this.workbench;
            final IWorkbenchWindow workbenchWindow = workbench2.getActiveWorkbenchWindow();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        String editorId = null;
                        IEditorDescriptor editor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(iFile.getLocation().toOSString(), iFile.getContentDescription().getContentType());
                        if (editor != null) {
                            editorId = editor.getId();
                        }
                        workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(iFile), editorId);
                    }
                    catch (PartInitException partInitException) {
                    }
                    catch (CoreException coreException) {}
                }
            });
        }
    }
}

