/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ods.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AxisProcessor {
    private List<Integer> columnCoordinates = new ArrayList<Integer>();

    public AxisProcessor() {
        this.addCoordinate(0);
    }

    public void addCoordinates(int[] values) {
        int i = 0;
        while (i < values.length) {
            this.addCoordinateWithoutSort(values[i]);
            ++i;
        }
        Collections.sort(this.columnCoordinates);
    }

    public void addCoordinate(int value) {
        if (this.addCoordinateWithoutSort(value)) {
            Collections.sort(this.columnCoordinates);
        }
    }

    public boolean addCoordinateWithoutSort(int value) {
        Integer index = value;
        if (!this.columnCoordinates.contains(index)) {
            this.columnCoordinates.add(index);
            return true;
        }
        return false;
    }

    public int[] getColumnCoordinatesInRange(int start, int end) {
        int startColumnIndex = this.getColumnIndexByCoordinate(start);
        int endColumnIndex = this.getColumnIndexByCoordinate(end);
        List<Integer> list = this.columnCoordinates.subList(startColumnIndex, endColumnIndex + 1);
        int length = list.size();
        int[] columnCoordinates = new int[length];
        int i = 0;
        while (i < length) {
            columnCoordinates[i] = list.get(i);
            ++i;
        }
        return columnCoordinates;
    }

    public int getColumnIndexByCoordinate(int value) {
        return this.columnCoordinates.indexOf(value);
    }

    public int[] getColumnWidths() {
        int length = this.columnCoordinates.size();
        int[] columnWidths = new int[length];
        int i = 0;
        while (i < length - 1) {
            columnWidths[i] = this.columnCoordinates.get(i + 1) - this.columnCoordinates.get(i);
            ++i;
        }
        return columnWidths;
    }
}

