/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.traces.events.validation;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentModel;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.InterfaceSignatureDefinition;
import org.eclipse.comma.traces.events.traceEvents.Event;
import org.eclipse.comma.traces.events.traceEvents.Import;
import org.eclipse.comma.traces.events.traceEvents.Notification;
import org.eclipse.comma.traces.events.traceEvents.Reply;
import org.eclipse.comma.traces.events.traceEvents.Signal;
import org.eclipse.comma.traces.events.traceEvents.TraceEvents;
import org.eclipse.comma.traces.events.traceEvents.TraceEventsPackage;
import org.eclipse.comma.traces.events.validation.AbstractTraceEventsValidator;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class TraceEventsValidator
extends AbstractTraceEventsValidator {
    @Inject
    protected IScopeProvider scopeProvider;

    @Check
    public void checkImportForValidity(Import imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", imp, (EStructuralFeature)TraceEventsPackage.eINSTANCE.getImport_ImportURI());
        } else {
            Resource r = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            EObject head = (EObject)IteratorExtensions.head((Iterator)r.getAllContents());
            if (!(head instanceof InterfaceSignatureDefinition) && !(head instanceof ComponentModel)) {
                this.error("The imported resource is not an interface signature nor a component definition", imp, (EStructuralFeature)TraceEventsPackage.eINSTANCE.getImport_ImportURI());
            }
        }
    }

    @Check
    public void checkUniqueComponentIds(TraceEvents traces) {
        HashMultimap multiMap = HashMultimap.create();
        EList<org.eclipse.comma.traces.events.traceEvents.Component> _components = traces.getComponents();
        for (org.eclipse.comma.traces.events.traceEvents.Component ci : _components) {
            multiMap.put((Object)ci.getComponentId(), (Object)ci);
        }
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (org.eclipse.comma.traces.events.traceEvents.Component d : duplicates) {
                this.error("Duplicate component instance name", d, (EStructuralFeature)TraceEventsPackage.Literals.COMPONENT__COMPONENT_ID);
            }
        }
    }

    @Check
    public void checkNumberOfParameters(Event e) {
        boolean _notEquals;
        if (e == null) {
            return;
        }
        int expectedNrParams = 0;
        if (e instanceof org.eclipse.comma.traces.events.traceEvents.Command) {
            Functions.Function1 _function = p -> {
                DIRECTION _direction = p.getDirection();
                return !Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
            };
            expectedNrParams = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)((org.eclipse.comma.traces.events.traceEvents.Command)e).getCommand().getParameters(), (Functions.Function1)_function));
        } else if (e instanceof Signal || e instanceof Notification) {
            expectedNrParams = e.getCommand().getParameters().size();
        } else if (e instanceof Reply) {
            boolean _not_1;
            boolean _not;
            Functions.Function1 _function_1 = p -> {
                DIRECTION _direction = p.getDirection();
                return !Objects.equal((Object)_direction, (Object)DIRECTION.IN);
            };
            expectedNrParams = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)((Reply)e).getCommand().getParameters(), (Functions.Function1)_function_1));
            InterfaceEvent _command = ((Reply)e).getCommand();
            boolean bl = _not = !(_command instanceof Command);
            if (_not) {
                return;
            }
            InterfaceEvent _command_1 = ((Reply)e).getCommand();
            Type retType = ((Command)_command_1).getType();
            boolean _isVoid = TypeUtilities.isVoid((Type)retType);
            boolean bl2 = _not_1 = !_isVoid;
            if (_not_1) {
                ++expectedNrParams;
            }
        }
        int _size = e.getParameters().size();
        boolean bl = _notEquals = expectedNrParams != _size;
        if (_notEquals) {
            this.error("Wrong number of parameters. Expected " + Integer.valueOf(expectedNrParams) + " parameters.", (EStructuralFeature)TraceEventsPackage.Literals.EVENT__COMMAND);
        }
    }

    @Check
    public void checkCorrectUseOfComponents(TraceEvents trace) {
        boolean _not;
        boolean _isEmpty = trace.getComponents().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Set componentTypes = IterableExtensions.toSet((Iterable)CommaUtilities.resolveProxy((EObject)trace, (Iterable)this.scopeProvider.getScope((EObject)trace, TraceEventsPackage.Literals.DUMMY__COMPONENT).getAllElements()));
            boolean unknownTypeFound = false;
            EList<org.eclipse.comma.traces.events.traceEvents.Component> _components = trace.getComponents();
            for (org.eclipse.comma.traces.events.traceEvents.Component cInstance : _components) {
                boolean _not_1;
                Functions.Function1 _function = it -> CommaUtilities.getFullyQualifiedNameAsString((NamedElement)it).equals(cInstance.getComponentType());
                boolean _exists = IterableExtensions.exists((Iterable)componentTypes, (Functions.Function1)_function);
                boolean bl2 = _not_1 = !_exists;
                if (!_not_1) continue;
                unknownTypeFound = true;
                this.error("Unknown component type", cInstance, (EStructuralFeature)TraceEventsPackage.Literals.COMPONENT__COMPONENT_TYPE);
            }
            if (unknownTypeFound) {
                return;
            }
            EList<Event> _events = trace.getEvents();
            for (Event ev : _events) {
                this.checkEvent(ev, componentTypes);
            }
        }
    }

    public void checkEvent(Event ev, Set<Component> componentTypes) {
        EObject _eContainer = ev.eContainer();
        TraceEvents root = (TraceEvents)_eContainer;
        boolean targetPort = true;
        EAttribute attrToHighlight = null;
        Functions.Function1 _function = it -> it.getComponentId().equals(ev.getSource());
        org.eclipse.comma.traces.events.traceEvents.Component cInstance = (org.eclipse.comma.traces.events.traceEvents.Component)IterableExtensions.findFirst(root.getComponents(), (Functions.Function1)_function);
        if (cInstance != null) {
            attrToHighlight = TraceEventsPackage.Literals.EVENT__SOURCE_PORT;
            targetPort = false;
        } else {
            Functions.Function1 _function_1 = it -> it.getComponentId().equals(ev.getTarget());
            cInstance = (org.eclipse.comma.traces.events.traceEvents.Component)IterableExtensions.findFirst(root.getComponents(), (Functions.Function1)_function_1);
            if (cInstance == null) {
                return;
            }
            attrToHighlight = TraceEventsPackage.Literals.EVENT__TARGET_PORT;
        }
        String cType = cInstance.getComponentType();
        Functions.Function1 _function_2 = it -> CommaUtilities.getFullyQualifiedNameAsString((NamedElement)it).equals(cType);
        Component componentModel = (Component)IterableExtensions.findFirst(componentTypes, (Functions.Function1)_function_2);
        String _xifexpression = null;
        _xifexpression = targetPort ? ev.getTargetPort() : ev.getSourcePort();
        String portName = _xifexpression;
        Functions.Function1 _function_3 = it -> it.getName().equals(portName);
        Port portDef = (Port)IterableExtensions.findFirst((Iterable)componentModel.getPorts(), (Functions.Function1)_function_3);
        if (portDef == null) {
            this.error("Port is not defined in the component model", ev, (EStructuralFeature)attrToHighlight);
            return;
        }
        boolean providedPort = portDef instanceof ProvidedPort;
        boolean _xor = targetPort ^ providedPort;
        if (_xor) {
            if (ev instanceof Command || ev instanceof Signal) {
                this.error("Only reply or notification is allowed for this port and this direction", ev, (EStructuralFeature)attrToHighlight);
            }
        } else if (ev instanceof Reply || ev instanceof Notification) {
            this.error("Only command or signal is allowed for this port and this direction", ev, (EStructuralFeature)attrToHighlight);
        }
    }
}

