/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.constraints;

import org.eclipse.comma.monitoring.lib.constraints.CConstraintValue;
import org.eclipse.comma.monitoring.lib.constraints.CFormula;
import org.eclipse.comma.monitoring.lib.constraints.CSequence;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CConstraintSequence
extends CFormula {
    protected int conditionIndex = 0;
    protected CSequence seq;

    public CConstraintSequence setConditionIndex(int i) {
        this.conditionIndex = i;
        return this;
    }

    public CConstraintSequence setSequence(CSequence s) {
        this.seq = s;
        return this;
    }

    public CSequence getSequence() {
        return this.seq;
    }

    @Override
    public CConstraintValue consume(CObservedMessage message) {
        CConstraintValue r = this.seq.consume(message);
        if (r == CConstraintValue.FALSE) {
            return CConstraintValue.TRUE;
        }
        if (r == CConstraintValue.TRUE) {
            if (!this.seq.getEnvironment().checkCondition(this.conditionIndex, message)) {
                return CConstraintValue.FALSE;
            }
            return CConstraintValue.TRUE;
        }
        return CConstraintValue.UNKNOWN;
    }
}

