/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2.participant;

import com.google.inject.Inject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationContext;
import org.eclipse.xtext.ui.refactoring2.participant.ResourceRelocationProcessor;

public class XtextMoveResourceParticipant
extends MoveParticipant
implements ISharableParticipant {
    @Inject
    private ResourceRelocationProcessor processor;
    private Change change;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        try {
            this.change = this.processor.createChange(this.getName(), ResourceRelocationContext.ChangeType.MOVE, pm);
            return this.processor.getIssues().getRefactoringStatus();
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (CoreException e) {
            return RefactoringStatus.create((IStatus)e.getStatus());
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.change;
    }

    public String getName() {
        return "Xtext move resource participant";
    }

    protected boolean initialize(Object element) {
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return true;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        Object destination;
        if (arguments instanceof MoveArguments && element instanceof IResource && ((destination = ((MoveArguments)arguments).getDestination()) instanceof IFolder || destination instanceof IProject)) {
            IFile destinationFile = ((IContainer)destination).getFile((IPath)new Path(((IResource)element).getName()));
            this.processor.addChangedResource((IResource)element, ((IResource)element).getFullPath(), destinationFile.getFullPath());
        }
    }
}

