/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.component.generator.plantuml;

import java.io.File;
import java.util.Map;
import net.sourceforge.plantuml.SourceFileReader;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.behavior.RequiredPort;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentPart;
import org.eclipse.comma.behavior.component.component.Connection;
import org.eclipse.comma.behavior.component.component.PortReference;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.generator.CommaGenerator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ComponentUmlGenerator
extends CommaGenerator {
    private final Component component;
    private static final String EXT_UML = ".plantuml";
    private URI outputURI;

    public ComponentUmlGenerator(Component component, IFileSystemAccess fsa) {
        super(String.valueOf(component.getName()) + EXT_UML, fsa);
        this.component = component;
    }

    public CharSequence getContent() {
        return this.toUmlComponentDiagram(this.component, null);
    }

    public void generate() {
        try {
            boolean _not;
            super.generate();
            String _name = this.component.getName();
            String _plus = String.valueOf(_name) + ".png";
            this.fsa.generateFile(_plus, (CharSequence)"");
            String _name_1 = this.component.getName();
            String _plus_1 = String.valueOf(_name_1) + EXT_UML;
            URI umlURI = URI.createURI((String)_plus_1).resolve(this.outputURI);
            String _fileString = umlURI.toFileString();
            File umlFile = new File(_fileString);
            SourceFileReader reader = new SourceFileReader(umlFile);
            boolean _isEmpty = reader.getGeneratedImages().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                reader.getGeneratedImages().get(0);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public URI setPrjURIForImages(URI prjURI) {
        URI _xblockexpression = null;
        URI projectPath = this.getOutputURI(prjURI);
        URI gen = URI.createURI((String)CommaFileSystemAccess.getGenerationFolder((IFileSystemAccess)this.fsa));
        _xblockexpression = this.outputURI = gen.resolve(projectPath);
        return _xblockexpression;
    }

    private URI getOutputURI(URI prjURI) {
        boolean _hasTrailingPathSeparator;
        boolean _not;
        URI outputDir;
        URI rURI = prjURI;
        boolean _isPlatform = rURI.isPlatform();
        if (_isPlatform) {
            IResource eclipseResource = ResourcesPlugin.getWorkspace().getRoot().findMember(rURI.toPlatformString(true));
            rURI = URI.createFileURI((String)eclipseResource.getRawLocation().toOSString());
        }
        if ((outputDir = this.getOutputConfiguration()) == null) {
            throw new IllegalArgumentException("Output directory was not set.");
        }
        boolean _isRelative = outputDir.isRelative();
        if (_isRelative) {
            outputDir = outputDir.resolve(rURI);
        }
        boolean bl = _not = !(_hasTrailingPathSeparator = outputDir.hasTrailingPathSeparator());
        if (_not) {
            outputDir.appendSegment("");
        }
        return outputDir;
    }

    private URI getOutputConfiguration() {
        IFileSystemAccess access = this.fsa;
        if (access instanceof CommaFileSystemAccess) {
            access = ((CommaFileSystemAccess)access).getIFileSystemAccess();
        }
        Path tempPath = new Path("DEFAULT_OUTPUT");
        if (access instanceof AbstractFileSystemAccess) {
            boolean _not;
            Map configs = ((AbstractFileSystemAccess)access).getOutputConfigurations();
            boolean _isEmpty = configs.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Path _path;
                String _outputDirectory = ((OutputConfiguration)configs.get("DEFAULT_OUTPUT")).getOutputDirectory();
                tempPath = _path = new Path(_outputDirectory);
            }
        }
        Object _xifexpression = null;
        boolean _hasTrailingSeparator = tempPath.hasTrailingSeparator();
        boolean _not_1 = !_hasTrailingSeparator;
        _xifexpression = _not_1 ? tempPath.addTrailingSeparator() : tempPath;
        Path path = _xifexpression;
        return URI.createFileURI((String)path.toString());
    }

    public CharSequence toUmlComponentDiagram(Component c, String instanceName) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        boolean isTopLevel = instanceName == null;
        StringConcatenation _builder = new StringConcatenation();
        if (isTopLevel) {
            _builder.append("@startuml");
            _builder.newLine();
        }
        _builder.append("component \"");
        if (!isTopLevel) {
            _builder.append(instanceName);
            _builder.append(" : ");
        }
        String _name = c.getName();
        _builder.append(_name);
        _builder.append("\" {");
        _builder.newLineIfNotEmpty();
        EList _ports = c.getPorts();
        for (Port port : _ports) {
            _builder.append("    ");
            if (port instanceof ProvidedPort) {
                _builder.append("portin");
            } else {
                _builder.append("portout");
            }
            _builder.append(" \"");
            String _name_1 = port.getName();
            _builder.append(_name_1, "    ");
            _builder.append(" : ");
            String _name_2 = port.getInterface().getName();
            _builder.append(_name_2, "    ");
            _builder.append("\" as ");
            String _name_3 = port.getName();
            _builder.append(_name_3, "    ");
            _builder.append("_");
            String _name_4 = c.getName();
            _builder.append(_name_4, "    ");
            _builder.newLineIfNotEmpty();
        }
        boolean _isEmpty = c.getParts().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("    ");
            _builder.newLine();
            EList<ComponentPart> _parts = c.getParts();
            for (ComponentPart part : _parts) {
                _builder.append("    ");
                CharSequence _umlComponentDiagram = this.toUmlComponentDiagram(part.getComponentType(), part.getName());
                _builder.append((Object)_umlComponentDiagram, "    ");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
        }
        EList<Connection> _connections = c.getConnections();
        for (Connection connection : _connections) {
            _builder.append("    ");
            CharSequence _portId = this.portId(connection.getFirstEnd());
            _builder.append((Object)_portId, "    ");
            CharSequence _connectionDirection = this.connectionDirection(connection);
            _builder.append((Object)_connectionDirection, "    ");
            CharSequence _portId_1 = this.portId(connection.getSecondEnd());
            _builder.append((Object)_portId_1, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        if (isTopLevel) {
            EList _ports_1 = this.component.getPorts();
            for (Port port_1 : _ports_1) {
                _builder.append("interface ");
                String _name_5 = port_1.getInterface().getName();
                _builder.append(_name_5);
                _builder.newLineIfNotEmpty();
                if (port_1 instanceof ProvidedPort) {
                    String _name_6 = ((ProvidedPort)port_1).getInterface().getName();
                    _builder.append(_name_6);
                    _builder.append(" -- ");
                    String _name_7 = ((ProvidedPort)port_1).getName();
                    _builder.append(_name_7);
                    _builder.append("_");
                    String _name_8 = this.component.getName();
                    _builder.append(_name_8);
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                String _name_9 = port_1.getName();
                _builder.append(_name_9);
                _builder.append("_");
                String _name_10 = this.component.getName();
                _builder.append(_name_10);
                _builder.append(" ..> ");
                String _name_11 = port_1.getInterface().getName();
                _builder.append(_name_11);
                _builder.append(" : use");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("@enduml");
            _builder.newLine();
        }
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence portId(PortReference pRef) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = pRef.getPort().getName();
        _builder.append(_name);
        _builder.append("_");
        ComponentPart _part = pRef.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            String _name_1 = pRef.getPart().getComponentType().getName();
            _builder.append(_name_1);
        } else {
            EObject _eContainer = pRef.eContainer().eContainer();
            String _name_2 = ((Component)_eContainer).getName();
            _builder.append(_name_2);
        }
        return _builder;
    }

    public CharSequence connectionDirection(Connection c) {
        StringConcatenation _xifexpression = null;
        Port _port = c.getFirstEnd().getPort();
        if (_port instanceof ProvidedPort) {
            StringConcatenation _xifexpression_1 = null;
            Port _port_1 = c.getSecondEnd().getPort();
            if (_port_1 instanceof ProvidedPort) {
                boolean _tripleEquals;
                StringConcatenation _xifexpression_2 = null;
                ComponentPart _part = c.getFirstEnd().getPart();
                boolean bl = _tripleEquals = _part == null;
                if (_tripleEquals) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(" ");
                    _builder.append("--> ");
                    _xifexpression_2 = _builder;
                } else {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(" ");
                    _builder_1.append("<-- ");
                    _xifexpression_2 = _builder_1;
                }
                _xifexpression_1 = _xifexpression_2;
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(" ");
                _builder_2.append("<-- ");
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            StringConcatenation _xifexpression_3 = null;
            Port _port_2 = c.getSecondEnd().getPort();
            if (_port_2 instanceof RequiredPort) {
                boolean _tripleEquals_1;
                StringConcatenation _xifexpression_4 = null;
                ComponentPart _part_1 = c.getFirstEnd().getPart();
                boolean bl = _tripleEquals_1 = _part_1 == null;
                if (_tripleEquals_1) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append(" ");
                    _builder_3.append("<-- ");
                    _xifexpression_4 = _builder_3;
                } else {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append(" ");
                    _builder_4.append("--> ");
                    _xifexpression_4 = _builder_4;
                }
                _xifexpression_3 = _xifexpression_4;
            } else {
                StringConcatenation _builder_5 = new StringConcatenation();
                _builder_5.append(" ");
                _builder_5.append("--> ");
                _xifexpression_3 = _builder_5;
            }
            _xifexpression = _xifexpression_3;
        }
        return _xifexpression;
    }
}

