/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.daemon.IndexStatisticsDaemon;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.compile.ASTVisitor;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.GenericStorablePreparedStatement;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.conn.GenericLanguageConnectionContext;

public class GenericStatement
implements Statement {
    private final SchemaDescriptor compilationSchema;
    private final String statementText;
    private final boolean isForReadOnly;
    private int prepareIsolationLevel;
    private GenericPreparedStatement preparedStmt;

    public GenericStatement(SchemaDescriptor schemaDescriptor, String string, boolean bl) {
        this.compilationSchema = schemaDescriptor;
        this.statementText = string;
        this.isForReadOnly = bl;
    }

    public PreparedStatement prepare(LanguageConnectionContext languageConnectionContext) throws StandardException {
        return this.prepMinion(languageConnectionContext, true, null, null, false);
    }

    public PreparedStatement prepare(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        return this.prepMinion(languageConnectionContext, true, null, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepMinion(LanguageConnectionContext languageConnectionContext, boolean bl, Object[] objectArray, SchemaDescriptor schemaDescriptor, boolean bl2) throws StandardException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        Timestamp timestamp = null;
        Timestamp timestamp2 = null;
        StatementContext statementContext = null;
        if (this.preparedStmt != null && this.preparedStmt.upToDate()) {
            return this.preparedStmt;
        }
        if (languageConnectionContext.getOptimizerTrace()) {
            languageConnectionContext.setOptimizerTraceOutput(this.getSource() + "\n");
        }
        if ((l = GenericStatement.getCurrentTimeMillis(languageConnectionContext)) != 0L) {
            timestamp = new Timestamp(l);
        }
        this.prepareIsolationLevel = languageConnectionContext.getPrepareIsolationLevel();
        boolean bl3 = false;
        if (this.preparedStmt == null) {
            if (bl) {
                this.preparedStmt = (GenericPreparedStatement)((GenericLanguageConnectionContext)languageConnectionContext).lookupStatement(this);
            }
            if (this.preparedStmt == null) {
                this.preparedStmt = new GenericPreparedStatement(this);
            } else {
                bl3 = true;
            }
        }
        Object object = this.preparedStmt;
        synchronized (object) {
            while (true) {
                if (bl3 && this.preparedStmt.referencesSessionSchema()) {
                    bl3 = false;
                    this.preparedStmt = new GenericPreparedStatement(this);
                    break;
                }
                if (this.preparedStmt.upToDate()) {
                    return this.preparedStmt;
                }
                if (!this.preparedStmt.compilingStatement) break;
                try {
                    this.preparedStmt.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            this.preparedStmt.compilingStatement = true;
            this.preparedStmt.setActivationClass(null);
        }
        try {
            Object object2 = object = languageConnectionContext.getLogStatementText() ? Monitor.getStream() : null;
            if (!this.preparedStmt.isStorable() || languageConnectionContext.getStatementDepth() == 0) {
                statementContext = languageConnectionContext.pushStatementContext(true, this.isForReadOnly, this.getSource(), null, false, 0L);
            }
            CompilerContext compilerContext = languageConnectionContext.pushCompilerContext(this.compilationSchema);
            if (this.prepareIsolationLevel != 0) {
                compilerContext.setScanIsolationLevel(this.prepareIsolationLevel);
            }
            if (bl2 || schemaDescriptor != null && schemaDescriptor.isSystemSchema() && schemaDescriptor.equals(this.compilationSchema)) {
                compilerContext.setReliability(0);
            }
            try {
                Object object3;
                Object object4;
                if (object != null) {
                    object4 = languageConnectionContext.getTransactionExecute().getActiveStateTxIdString();
                    object.printlnWithHeader("(XID = " + (String)object4 + "), " + "(SESSIONID = " + languageConnectionContext.getInstanceNumber() + "), " + "(DATABASE = " + languageConnectionContext.getDbname() + "), " + "(DRDAID = " + languageConnectionContext.getDrdaID() + "), Begin compiling prepared statement: " + this.getSource() + " :End prepared statement");
                }
                object4 = compilerContext.getParser();
                compilerContext.setCurrentDependent(this.preparedStmt);
                StatementNode statementNode = object4.parseStatement(this.statementText, objectArray);
                l2 = GenericStatement.getCurrentTimeMillis(languageConnectionContext);
                this.walkAST(languageConnectionContext, statementNode, 0);
                DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
                int n = dataDictionary == null ? 0 : dataDictionary.startReading(languageConnectionContext);
                try {
                    languageConnectionContext.beginNestedTransaction(true);
                    statementNode.bindStatement();
                    l3 = GenericStatement.getCurrentTimeMillis(languageConnectionContext);
                    this.walkAST(languageConnectionContext, statementNode, 1);
                    if (this.preparedStmt.referencesSessionSchema(statementNode) && bl3) {
                        ((GenericLanguageConnectionContext)languageConnectionContext).removeStatement(this);
                    }
                    statementNode.optimizeStatement();
                    l4 = GenericStatement.getCurrentTimeMillis(languageConnectionContext);
                    this.walkAST(languageConnectionContext, statementNode, 2);
                    if (object != null) {
                        object3 = languageConnectionContext.getTransactionExecute().getActiveStateTxIdString();
                        object.printlnWithHeader("(XID = " + (String)object3 + "), " + "(SESSIONID = " + languageConnectionContext.getInstanceNumber() + "), " + "(DATABASE = " + languageConnectionContext.getDbname() + "), " + "(DRDAID = " + languageConnectionContext.getDrdaID() + "), End compiling prepared statement: " + this.getSource() + " :End prepared statement");
                    }
                }
                catch (StandardException standardException) {
                    languageConnectionContext.commitNestedTransaction();
                    if (object != null) {
                        String string = languageConnectionContext.getTransactionExecute().getActiveStateTxIdString();
                        object.printlnWithHeader("(XID = " + string + "), " + "(SESSIONID = " + languageConnectionContext.getInstanceNumber() + "), " + "(DATABASE = " + languageConnectionContext.getDbname() + "), " + "(DRDAID = " + languageConnectionContext.getDrdaID() + "), Error compiling prepared statement: " + this.getSource() + " :End prepared statement");
                    }
                    throw standardException;
                }
                finally {
                    if (dataDictionary != null) {
                        dataDictionary.doneReading(n, languageConnectionContext);
                    }
                }
                try {
                    IndexStatisticsDaemon indexStatisticsDaemon;
                    object3 = statementNode.generate(this.preparedStmt.getByteCodeSaver());
                    l5 = GenericStatement.getCurrentTimeMillis(languageConnectionContext);
                    if (l5 != 0L) {
                        timestamp2 = new Timestamp(l5);
                    }
                    this.preparedStmt.setConstantAction(statementNode.makeConstantAction());
                    this.preparedStmt.setSavedObjects(compilerContext.getSavedObjects());
                    this.preparedStmt.setRequiredPermissionsList(compilerContext.getRequiredPermissionsList());
                    this.preparedStmt.setActivationClass((GeneratedClass)object3);
                    this.preparedStmt.setNeedsSavepoint(statementNode.needsSavepoint());
                    this.preparedStmt.setCursorInfo((CursorInfo)compilerContext.getCursorInfo());
                    this.preparedStmt.setIsAtomic(statementNode.isAtomic());
                    this.preparedStmt.setExecuteStatementNameAndSchema(statementNode.executeStatementName(), statementNode.executeSchemaName());
                    this.preparedStmt.setSPSName(statementNode.getSPSName());
                    this.preparedStmt.completeCompile(statementNode);
                    this.preparedStmt.setCompileTimeWarnings(compilerContext.getWarnings());
                    TableDescriptor[] tableDescriptorArray = statementNode.updateIndexStatisticsFor();
                    if (tableDescriptorArray.length > 0 && (indexStatisticsDaemon = languageConnectionContext.getDataDictionary().getIndexStatsRefresher(true)) != null) {
                        for (int i = 0; i < tableDescriptorArray.length; ++i) {
                            indexStatisticsDaemon.schedule(tableDescriptorArray[i]);
                        }
                    }
                }
                catch (StandardException standardException) {
                    languageConnectionContext.commitNestedTransaction();
                    throw standardException;
                }
                if (languageConnectionContext.getRunTimeStatisticsMode()) {
                    this.preparedStmt.setCompileTimeMillis(l2 - l, l3 - l2, l4 - l3, l5 - l4, l5 - l, timestamp, timestamp2);
                }
            }
            finally {
                languageConnectionContext.popCompilerContext(compilerContext);
            }
        }
        catch (StandardException standardException) {
            if (bl3) {
                ((GenericLanguageConnectionContext)languageConnectionContext).removeStatement(this);
            }
            throw standardException;
        }
        finally {
            GenericPreparedStatement genericPreparedStatement = this.preparedStmt;
            synchronized (genericPreparedStatement) {
                this.preparedStmt.compilingStatement = false;
                this.preparedStmt.notifyAll();
            }
        }
        languageConnectionContext.commitNestedTransaction();
        if (statementContext != null) {
            languageConnectionContext.popStatementContext(statementContext, null);
        }
        return this.preparedStmt;
    }

    private void walkAST(LanguageConnectionContext languageConnectionContext, Visitable visitable, int n) throws StandardException {
        ASTVisitor aSTVisitor = languageConnectionContext.getASTVisitor();
        if (aSTVisitor != null) {
            aSTVisitor.begin(this.statementText, n);
            visitable.accept(aSTVisitor);
            aSTVisitor.end(n);
        }
    }

    public PreparedStatement prepareStorable(LanguageConnectionContext languageConnectionContext, PreparedStatement preparedStatement, Object[] objectArray, SchemaDescriptor schemaDescriptor, boolean bl) throws StandardException {
        if (preparedStatement == null) {
            preparedStatement = new GenericStorablePreparedStatement(this);
        } else {
            ((GenericPreparedStatement)preparedStatement).statement = this;
        }
        this.preparedStmt = (GenericPreparedStatement)preparedStatement;
        return this.prepMinion(languageConnectionContext, false, objectArray, schemaDescriptor, bl);
    }

    public String getSource() {
        return this.statementText;
    }

    public String getCompilationSchema() {
        return this.compilationSchema.getDescriptorName();
    }

    private static long getCurrentTimeMillis(LanguageConnectionContext languageConnectionContext) {
        if (languageConnectionContext.getStatisticsTiming()) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStmt;
    }

    public boolean equals(Object object) {
        if (object instanceof GenericStatement) {
            GenericStatement genericStatement = (GenericStatement)object;
            return this.statementText.equals(genericStatement.statementText) && this.isForReadOnly == genericStatement.isForReadOnly && this.compilationSchema.equals(genericStatement.compilationSchema) && this.prepareIsolationLevel == genericStatement.prepareIsolationLevel;
        }
        return false;
    }

    public int hashCode() {
        return this.statementText.hashCode();
    }
}

