/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.impl;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.dirigible.ide.workspace.impl.Container;
import org.eclipse.dirigible.ide.workspace.impl.File;
import org.eclipse.dirigible.ide.workspace.impl.Folder;
import org.eclipse.dirigible.ide.workspace.impl.Messages;
import org.eclipse.dirigible.ide.workspace.impl.Resource;
import org.eclipse.dirigible.ide.workspace.impl.Workspace;
import org.eclipse.dirigible.ide.workspace.impl.event.ResourceChangeEvent;
import org.eclipse.dirigible.repository.logging.Logger;

public class Project
extends Container
implements IProject {
    private static final String METHOD_NOT_SUPPORTED = Messages.Project_METHOD_NOT_SUPPORTED;
    private static final String COULD_NOT_CREATE_PROJECT = Messages.Project_COULD_NOT_CREATE_PROJECT;
    private static final String PROJECT_ALREADY_EXIST = Messages.Project_PROJECT_ALREADY_EXIST;
    private static final Logger logger = Logger.getLogger(Project.class);
    private boolean opened = true;
    private IProjectDescription description;

    public Project(IPath path, Workspace workspace) {
        super(path, workspace);
        if (this.description == null) {
            this.description = this.createDescriptor(this);
        }
    }

    public void build(int arg0, IProgressMonitor arg1) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void build(int arg0, String arg1, Map arg2, IProgressMonitor arg3) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void close(IProgressMonitor arg0) throws CoreException {
        this.opened = false;
    }

    public void create(IProgressMonitor monitor) throws CoreException {
        monitor = Resource.monitorWrapper(monitor);
        try {
            IStatus pathValidation;
            if (monitor != null) {
                monitor.beginTask("project creation", -1);
            }
            if (!(pathValidation = this.workspace.validatePath(this.path.toString(), 4)).isOK()) {
                throw new CoreException(pathValidation);
            }
            if (this.exists()) {
                throw new CoreException(Project.createErrorStatus(PROJECT_ALREADY_EXIST));
            }
            try {
                this.getEntity().create();
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new CoreException(Project.createErrorStatus(String.format(COULD_NOT_CREATE_PROJECT, ex.getMessage())));
            }
            this.workspace.notifyResourceChanged(new ResourceChangeEvent(this, 1));
            if (this.description == null) {
                this.description = this.createDescriptor(this);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private IProjectDescription createDescriptor(final Project project) {
        IProjectDescription projectDescription = new IProjectDescription(){

            public void setReferencedProjects(IProject[] projects) {
            }

            public void setNatureIds(String[] natures) {
            }

            public void setName(String projectName) {
            }

            public void setLocationURI(URI location) {
            }

            public void setLocation(IPath location) {
            }

            public void setDynamicReferences(IProject[] projects) {
            }

            public void setComment(String comment) {
            }

            public void setBuildSpec(ICommand[] buildSpec) {
            }

            public void setBuildConfigs(String[] configNames) {
            }

            public void setBuildConfigReferences(String configName, IBuildConfiguration[] references) {
            }

            public void setActiveBuildConfig(String configName) {
            }

            public ICommand newCommand() {
                return null;
            }

            public boolean hasNature(String natureId) {
                return false;
            }

            public IProject[] getReferencedProjects() {
                return new IProject[0];
            }

            public String[] getNatureIds() {
                return new String[0];
            }

            public String getName() {
                return project.getName();
            }

            public URI getLocationURI() {
                return project.getLocationURI();
            }

            public IPath getLocation() {
                return project.getLocation();
            }

            public IProject[] getDynamicReferences() {
                return new IProject[0];
            }

            public String getComment() {
                return null;
            }

            public ICommand[] getBuildSpec() {
                return new ICommand[0];
            }

            public IBuildConfiguration[] getBuildConfigReferences(String configName) {
                return null;
            }
        };
        return projectDescription;
    }

    public void create(IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        this.description = description;
        this.create(monitor);
    }

    public void create(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException(METHOD_NOT_SUPPORTED);
    }

    public void delete(boolean deleteContent, boolean force, IProgressMonitor monitor) throws CoreException {
        int flags = (deleteContent ? 4 : 8) | (force ? 1 : 0);
        this.delete(flags, monitor);
    }

    @Override
    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.workspace.notifyResourceChanged(new ResourceChangeEvent(this, 4));
        super.delete(updateFlags, monitor);
    }

    public IContentTypeMatcher getContentTypeMatcher() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IProjectDescription getDescription() throws CoreException {
        return this.description;
    }

    public IFile getFile(String name) {
        IPath resourcePath = this.path.append(name);
        return new File(resourcePath, this.workspace);
    }

    public IFolder getFolder(String name) {
        IPath resourcePath = this.path.append(name);
        return new Folder(resourcePath, this.workspace);
    }

    public IProjectNature getNature(String arg0) throws CoreException {
        return null;
    }

    @Override
    public IPathVariableManager getPathVariableManager() {
        return null;
    }

    @Deprecated
    public IPath getPluginWorkingLocation(IPluginDescriptor plugin) {
        return this.getWorkingLocation(plugin.getUniqueIdentifier());
    }

    public IProject[] getReferencedProjects() throws CoreException {
        return new IProject[0];
    }

    public IProject[] getReferencingProjects() {
        return new IProject[0];
    }

    public IPath getWorkingLocation(String id) {
        throw new UnsupportedOperationException();
    }

    public boolean hasNature(String arg0) throws CoreException {
        return false;
    }

    public boolean isNatureEnabled(String arg0) throws CoreException {
        return false;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public void move(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        int flags = force ? 1 : 0;
        this.move(description, flags, monitor);
    }

    public void open(IProgressMonitor monitor) throws CoreException {
        this.open(0, monitor);
    }

    public void open(int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.opened = true;
    }

    public void setDescription(IProjectDescription projectDescription, IProgressMonitor arg1) throws CoreException {
        this.description = projectDescription;
    }

    public void setDescription(IProjectDescription projectDescription, int arg1, IProgressMonitor arg2) throws CoreException {
        this.description = projectDescription;
    }

    public void loadSnapshot(int arg0, URI arg1, IProgressMonitor arg2) throws CoreException {
    }

    public void saveSnapshot(int arg0, URI arg1, IProgressMonitor arg2) throws CoreException {
    }

    public void build(IBuildConfiguration config, int kind, IProgressMonitor monitor) throws CoreException {
    }

    public IBuildConfiguration getActiveBuildConfig() throws CoreException {
        return null;
    }

    public IBuildConfiguration getBuildConfig(String configName) throws CoreException {
        return null;
    }

    public IBuildConfiguration[] getBuildConfigs() throws CoreException {
        return null;
    }

    public IBuildConfiguration[] getReferencedBuildConfigs(String configName, boolean includeMissing) throws CoreException {
        return null;
    }

    public boolean hasBuildConfig(String configName) throws CoreException {
        return false;
    }
}

