/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.command;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.common.status.DefaultProgressMonitor;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.jgit.command.Messages;
import org.eclipse.dirigible.ide.jgit.property.tester.GitProjectPropertyTest;
import org.eclipse.dirigible.ide.jgit.utils.CommandHandlerUtils;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.publish.PublishManager;
import org.eclipse.dirigible.ide.workspace.ui.commands.AbstractWorkspaceHandler;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class PullCommandHandler
extends AbstractWorkspaceHandler {
    private static final String DO_YOU_WANT_TO_PUBLISH_THE_PROJECT_YOU_JUST_PULLED = "Do you want to publish the project(s) you just pulled?";
    private static final String PUBLISH_PULLED_PROJECT = "Publish Pulled Project?";
    private static final String TASK_PULLING_FROM_REMOTE_REPOSITORY = Messages.PullCommandHandler_TASK_PULLING_FROM_REMOTE_REPOSITORY;
    private static final String PROJECT_HAS_D_CONFILCTING_FILES_DO_PUSH_OR_RESET = Messages.PushCommandHandler_PROJECT_HAS_D_CONFILCTING_FILES_DO_PUSH_OR_RESET;
    private static final String CONFLICTING_FILES = Messages.PushCommandHandler_CONFLICTING_FILES;
    private static final String THIS_IS_NOT_A_GIT_PROJECT = Messages.PushCommandHandler_THIS_IS_NOT_A_GIT_PROJECT;
    private static final String CHANGES_BRANCH = "changes_branch_";
    private static final String SLASH = "/";
    private static final String DOT_GIT = ".git";
    private static final String MASTER = "master";
    private static final String INCORRECT_USERNAME_AND_OR_PASSWORD_OR_GIT_REPOSITORY_URI = Messages.PushCommandHandler_INCORRECT_USERNAME_AND_OR_PASSWORD_OR_GIT_REPOSITORY_URI;
    private static final String PLEASE_CHECK_IF_PROXY_SETTINGS_ARE_SET_PROPERLY = Messages.PushCommandHandler_PLEASE_CHECK_IF_PROXY_SETTINGS_ARE_SET_PROPERLY;
    private static final String PLEASE_SELECT_ONE = Messages.PushCommandHandler_PLEASE_SELECT_ONE;
    private static final String SELECT_CLONED = Messages.PullCommandHandler_PLEASE_SELECT_ONE;
    private static final String ERROR_DURING_PULL = Messages.PullCommandHandler_ERROR_DURING_PULL;
    private static final String WHILE_PULLING_PROJECT_ERROR_OCCURED = Messages.PullCommandHandler_WHILE_PULLING_PROJECT_ERROR_OCCURED;
    private static final String PROJECT_HAS_BEEN_PULLED_FROM_REMOTE_REPOSITORY = Messages.PullCommandHandler_PROJECT_HAS_BEEN_PULLED_FROM_REMOTE_REPOSITORY;
    private static final String NO_PROJECT_IS_SELECTED_FOR_PULL = Messages.PullCommandHandler_NO_PROJECT_IS_SELECTED_FOR_PULL;
    private static final String NO_VALID_PROJECT_IS_SELECTED_FOR_PULL = Messages.PullCommandHandler_NO_VALID_PROJECT_IS_SELECTED_FOR_PULL;
    private static final Logger logger = Logger.getLogger(PullCommandHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection.isEmpty()) {
            logger.warn(NO_PROJECT_IS_SELECTED_FOR_PULL);
            StatusLineManagerUtil.setWarningMessage((String)NO_PROJECT_IS_SELECTED_FOR_PULL);
            MessageDialog.openWarning(null, (String)NO_PROJECT_IS_SELECTED_FOR_PULL, (String)PLEASE_SELECT_ONE);
            return null;
        }
        IProject[] projects = CommandHandlerUtils.getProjects(selection, logger);
        if (projects.length == 0) {
            logger.warn(NO_PROJECT_IS_SELECTED_FOR_PULL);
            StatusLineManagerUtil.setWarningMessage((String)NO_PROJECT_IS_SELECTED_FOR_PULL);
            MessageDialog.openWarning(null, (String)NO_PROJECT_IS_SELECTED_FOR_PULL, (String)PLEASE_SELECT_ONE);
            return null;
        }
        DefaultProgressMonitor monitor = new DefaultProgressMonitor();
        monitor.beginTask(TASK_PULLING_FROM_REMOTE_REPOSITORY, -1);
        ArrayList<IProject> publishedProjects = new ArrayList<IProject>();
        GitProjectPropertyTest tester = new GitProjectPropertyTest();
        boolean atLeastOne = false;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject selectedProject = iProjectArray[n2];
            if (tester.test(selectedProject, null, null, true)) {
                logger.debug(String.format("Start pulling %s project...", selectedProject.getName()));
                boolean pulled = this.pullProjectFromGitRepository(selectedProject);
                atLeastOne = atLeastOne ? atLeastOne : pulled;
                logger.debug(String.format("Pull of the Project %s finished.", selectedProject.getName()));
                publishedProjects.add(selectedProject);
            } else {
                logger.debug(String.format("Project %s is local only", selectedProject));
                MessageDialog.openInformation(null, (String)NO_VALID_PROJECT_IS_SELECTED_FOR_PULL, (String)SELECT_CLONED);
            }
            ++n2;
        }
        this.refreshWorkspace();
        if (atLeastOne) {
            this.publishProjects(publishedProjects.toArray(new IProject[0]));
        }
        monitor.done();
        return null;
    }

    /*
     * Exception decompiling
     */
    boolean pullProjectFromGitRepository(IProject selectedProject) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void publishProjects(IProject[] projects) {
        if (projects.length > 0 && MessageDialog.openConfirm(null, (String)PUBLISH_PULLED_PROJECT, (String)DO_YOU_WANT_TO_PUBLISH_THE_PROJECT_YOU_JUST_PULLED)) {
            IProject[] iProjectArray = projects;
            if (projects.length != 0) {
                IProject project = iProjectArray[0];
                try {
                    PublishManager.publishProject((IProject)project, (HttpServletRequest)CommonIDEParameters.getRequest());
                    StatusLineManagerUtil.setInfoMessage((String)String.format(PROJECT_HAS_BEEN_PULLED_FROM_REMOTE_REPOSITORY, project.getName()));
                }
                catch (PublishException e) {
                    String errorMessage = String.format(WHILE_PULLING_PROJECT_ERROR_OCCURED, project.getName());
                    logger.error(errorMessage, (Throwable)e);
                    MessageDialog.openError(null, (String)ERROR_DURING_PULL, (String)errorMessage);
                }
            }
        }
    }
}

