/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.integration.test.unit.internal;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.integration.internal.ViewCustXpParser;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.internal.StatusUtils;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.jmock.core.Constraint;

public class ViewCustXpParserTest
extends MockObjectTestCase {
    private static final String XP_ID = "org.eclipse.platform.discovery.integration.searchconsole";
    private static final String XP_ELEMENT_NAME = "slavecontroller";
    private static final String IMPL_ATTR = "impl";
    private Mock<ILogger> logger;
    private Mock<IExtensionRegistry> extRegistry;
    private Mock<IExtensionPoint> searchConsoleExtensionPoint;
    private ViewCustXpParser<Object> testParser;
    private Mock<IConfigurationElement> configElement;
    private Mock<IConfigurationElement> configElementWithExc;
    private Object instantiatableObject;
    private CoreException exceptionThrown;

    protected void setUp() throws Exception {
        this.instantiatableObject = new Object();
        this.logger = this.mock(ILogger.class);
        this.setupConfigElements();
        this.setUpExtensionPoint();
        this.setUpExtensionRegistry();
        this.testParser = new ViewCustXpParser<Object>((IExtensionRegistry)this.extRegistry.proxy(), XP_ID, XP_ELEMENT_NAME){

            protected ILogger logger() {
                return (ILogger)ViewCustXpParserTest.this.logger.proxy();
            }

            protected String implementationAttributeName() {
                return ViewCustXpParserTest.IMPL_ATTR;
            }
        };
    }

    private void setUpExtensionPoint() {
        this.searchConsoleExtensionPoint = this.mock(IExtensionPoint.class);
        this.searchConsoleExtensionPoint.stubs().method("getConfigurationElements").will(this.returnValue(new IConfigurationElement[]{(IConfigurationElement)this.configElement.proxy(), (IConfigurationElement)this.configElementWithExc.proxy()}));
    }

    private void setUpExtensionRegistry() {
        this.extRegistry = this.mock(IExtensionRegistry.class);
        this.extRegistry.stubs().method("getExtensionPoint").with((Constraint)this.eq(XP_ID)).will(this.returnValue(this.searchConsoleExtensionPoint.proxy()));
    }

    private void setupConfigElements() {
        this.configElement = this.mock(IConfigurationElement.class);
        this.configElement.stubs().method("createExecutableExtension").with((Constraint)this.eq(IMPL_ATTR)).will(this.returnValue(this.instantiatableObject));
        this.configElement.stubs().method("getName").will(this.returnValue(XP_ELEMENT_NAME));
        this.exceptionThrown = new CoreException(StatusUtils.statusError((String)"TEST"));
        this.configElementWithExc = this.mock(IConfigurationElement.class);
        this.configElementWithExc.stubs().method("createExecutableExtension").with((Constraint)this.eq(IMPL_ATTR)).will(this.throwException((Throwable)this.exceptionThrown));
        this.configElementWithExc.stubs().method("getName").will(this.returnValue(XP_ELEMENT_NAME));
    }

    public void testReadSlaveControllers() {
        this.logger.expects(this.once()).method("logError").with(ANYTHING, (Constraint)this.eq(this.exceptionThrown));
        List result = this.testParser.readContributions();
        ViewCustXpParserTest.assertEquals((String)"One element expected", (int)1, (int)result.size());
        ViewCustXpParserTest.assertTrue((String)"Unexpected slave controller", (result.iterator().next() == this.instantiatableObject ? 1 : 0) != 0);
    }
}

