/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.core.api.ISearchFavoritesMasterController;
import org.eclipse.platform.discovery.core.internal.favorites.ISearchFavoritesControllerOutputView;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IMasterDiscoveryView;
import org.eclipse.platform.discovery.ui.api.IResultsViewAccessor;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.ui.api.impl.LabeledSelection;
import org.eclipse.platform.discovery.ui.internal.dnd.LocalContextSelectionTransfer;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.util.ControlBackgroundImageManager;
import org.eclipse.platform.discovery.ui.internal.view.ICustomizableView;
import org.eclipse.platform.discovery.ui.internal.view.ViewProgressMonitor;
import org.eclipse.platform.discovery.ui.internal.view.dnd.impl.DragSrcInteractionListener;
import org.eclipse.platform.discovery.ui.internal.view.favorites.FavoritesContentProvider;
import org.eclipse.platform.discovery.ui.internal.view.impl.AbstractDiscoveryView;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchFavoritesDropListener;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.DiscoveryTreeViewerFactory;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class SearchFavoritesView
extends AbstractDiscoveryView<ISearchFavoritesControllerOutputView, ISearchFavoritesMasterController>
implements ISearchFavoritesControllerOutputView,
ICustomizableView,
IMasterDiscoveryView {
    private ISearchFavoritesMasterController controller;
    private ViewProgressMonitor viewProgressMonitor;
    private TreeViewer treeViewer;
    private DiscoveryTreeViewerFactory treeViewerFactory;
    private Composite treeViewerComposite;
    private Composite parentComposite;
    private ControlBackgroundImageManager treeViewerBgImageManager;
    private ControlBackgroundImageManager treeViewerCompositeBgImageManager;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.parentComposite = parent;
        Composite composite = this.formToolkit.createComposite(parent);
        composite.setLayout((Layout)this.createGridLayout());
        this.treeViewerFactory = this.createTreeViewerFactory();
        this.treeViewerComposite = this.formToolkit.createComposite(composite);
        this.treeViewerCompositeBgImageManager = new ControlBackgroundImageManager((Control)this.treeViewerComposite);
        this.treeViewerComposite.setBackground(this.getGradientEnd());
        this.treeViewerComposite.setForeground(this.getGradientStart());
        this.treeViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewerComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                SearchFavoritesView.this.treeViewerCompositeBgImageManager.setBackgroundGradient(SearchFavoritesView.this.getGradientStart(), SearchFavoritesView.this.getGradientEnd(), true);
            }
        });
        this.treeViewerComposite.setLayout((Layout)this.createGridLayout());
        this.viewProgressMonitor = new ViewProgressMonitor(composite, Arrays.asList(this.treeViewerComposite));
        this.viewProgressMonitor.getControl().setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        this.getProgressMonitor().beginTask(DiscoveryUIMessages.INITIALIZATION_IN_PROGRESS_TASK, -1);
    }

    private GridLayout createGridLayout() {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected DiscoveryTreeViewerFactory createTreeViewerFactory() {
        return new DiscoveryTreeViewerFactory(){

            @Override
            protected ITreeContentProvider contentProvider(List<IGenericViewCustomization> viewCustomizations) {
                return new FavoritesContentProvider(viewCustomizations);
            }

            @Override
            public IResultsViewAccessor createTreeViewer(Composite parent, Set<? extends IGenericViewCustomization> viewCustomizations, Set<IContributedAction> actions, IDiscoveryEnvironment env) {
                IResultsViewAccessor accessor = super.createTreeViewer(parent, viewCustomizations, actions, env);
                return accessor;
            }

            @Override
            protected DragSrcInteractionListener.ISelectionObtainer treeViewerSelectionObtainer(final TreeViewer viewer) {
                return new DragSrcInteractionListener.ISelectionObtainer(){

                    @Override
                    public IStructuredSelection getSelection() {
                        return (IStructuredSelection)viewer.getSelection();
                    }
                };
            }

            @Override
            protected IToolBarManager createToolbar(Composite parent, int style) {
                return SearchFavoritesView.this.getViewSite().getActionBars().getToolBarManager();
            }
        };
    }

    public void showFavorites(final Set<Object> favorites) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ITreeContentProvider cp = (ITreeContentProvider)SearchFavoritesView.this.treeViewer.getContentProvider();
                List<Object> oldRootElements = Arrays.asList(cp.getElements(SearchFavoritesView.this.treeViewer.getInput()));
                List<Object> alreadyExpanded = Arrays.asList(SearchFavoritesView.this.treeViewer.getExpandedElements());
                SearchFavoritesView.this.treeViewer.setInput((Object)favorites);
                List<Object> newRootElements = Arrays.asList(cp.getElements(SearchFavoritesView.this.treeViewer.getInput()));
                ArrayList<Object> toExpand = new ArrayList<Object>();
                toExpand.addAll(newRootElements);
                toExpand.removeAll(oldRootElements);
                toExpand.addAll(alreadyExpanded);
                SearchFavoritesView.this.treeViewer.setExpandedElements(toExpand.toArray());
                SearchFavoritesView.this.treeViewer.refresh();
            }
        };
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.viewProgressMonitor;
    }

    @Override
    public void initializationCompleted() {
        IResultsViewAccessor accessor = this.treeViewerFactory.createTreeViewer(this.treeViewerComposite, this.viewCustomizations(), this.viewActions(), this.getEnvironment());
        this.treeViewer = accessor.getTreeViewer();
        this.treeViewerBgImageManager = new ControlBackgroundImageManager(this.treeViewer.getControl());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SearchFavoritesView.this.setResultSelection(new LabeledSelection((ILabelProvider)SearchFavoritesView.this.treeViewer.getLabelProvider(), (IStructuredSelection)event.getSelection()));
            }
        });
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewerBgImageManager.setBackgroundGradient(this.getGradientStart(), this.getGradientEnd(), true);
        this.treeViewer.getTree().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                SearchFavoritesView.this.treeViewerBgImageManager.setBackgroundGradient(SearchFavoritesView.this.getGradientStart(), SearchFavoritesView.this.getGradientEnd(), true);
            }
        });
        this.installSearchFavoritesDropSupport(this.treeViewer);
        this.parentComposite.layout(true, true);
        super.initializationCompleted();
    }

    private void installSearchFavoritesDropSupport(TreeViewer viewer) {
        Transfer[] transfers = new Transfer[]{LocalContextSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        viewer.addDropSupport(3, transfers, (DropTargetListener)new SearchFavoritesDropListener(transfers, this.controller));
    }

    @Override
    public void registerViewCustomization(IGenericViewCustomization customization) {
        if (!(customization instanceof ISearchFavoritesViewCustomization)) {
            throw new IllegalArgumentException("The view customization should be instance of ISearchFavoritesViewCustomization");
        }
        super.registerViewCustomization(customization);
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    @Override
    public void setStatusMessage(String message) {
        this.viewProgressMonitor.setMessage(message);
    }

    public ISearchFavoritesControllerOutputView getControllerView() {
        return this;
    }

    public void registerController(ISearchFavoritesMasterController controller) {
        this.controller = controller;
    }

    public void showUnsupportedContentWindow() {
        this.showErrorMessageInDialog(DiscoveryUIMessages.SearchFavoritesView_UnsupportedDataContentMsg);
    }

    public void showNoContentFoundWindow() {
        this.showErrorMessageInDialog(DiscoveryUIMessages.SearchFavoritesView_EmptyDataMsg);
    }

    private void showErrorMessageInDialog(final String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog errDialog = new MessageDialog(SearchFavoritesView.this.parentComposite.getShell(), DiscoveryUIMessages.ErrorHandler_DIALOG_TITLE, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                errDialog.open();
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        this.treeViewerCompositeBgImageManager.disposeResources();
        this.treeViewerBgImageManager.disposeResources();
    }
}

