/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.spi.migration.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edapt.internal.migration.DiagnosticException;
import org.eclipse.emf.edapt.internal.migration.impl.LazyExtentMap;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.AttributeSlot;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.MigrationFactory;
import org.eclipse.emf.edapt.spi.migration.MigrationPackage;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.ModelResource;
import org.eclipse.emf.edapt.spi.migration.ReferenceSlot;
import org.eclipse.emf.edapt.spi.migration.Repository;
import org.eclipse.emf.edapt.spi.migration.Slot;
import org.eclipse.emf.edapt.spi.migration.Type;

public class ModelImpl
extends EObjectImpl
implements Model {
    protected Metamodel metamodel;
    protected EList<Type> types;
    protected static final boolean REFLECTION_EDEFAULT = false;
    protected boolean reflection = false;
    protected EList<ModelResource> resources;

    protected ModelImpl() {
    }

    protected EClass eStaticClass() {
        return MigrationPackage.Literals.MODEL;
    }

    @Override
    public Metamodel getMetamodel() {
        if (this.metamodel != null && ((EObject)this.metamodel).eIsProxy()) {
            InternalEObject oldMetamodel = (InternalEObject)this.metamodel;
            this.metamodel = (Metamodel)this.eResolveProxy(oldMetamodel);
            if (this.metamodel != oldMetamodel && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldMetamodel, (Object)this.metamodel));
            }
        }
        return this.metamodel;
    }

    public Metamodel basicGetMetamodel() {
        return this.metamodel;
    }

    @Override
    public void setMetamodel(Metamodel newMetamodel) {
        Metamodel oldMetamodel = this.metamodel;
        this.metamodel = newMetamodel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldMetamodel, (Object)this.metamodel));
        }
    }

    @Override
    public EList<Type> getTypes() {
        if (this.types == null) {
            this.types = new EObjectContainmentWithInverseEList(Type.class, (InternalEObject)this, 1, 2);
        }
        return this.types;
    }

    @Override
    public boolean isReflection() {
        return this.reflection;
    }

    @Override
    public void setReflection(boolean newReflection) {
        boolean oldReflection = this.reflection;
        this.reflection = newReflection;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldReflection, this.reflection));
        }
    }

    @Override
    public EList<ModelResource> getResources() {
        if (this.resources == null) {
            this.resources = new EObjectContainmentWithInverseEList(ModelResource.class, (InternalEObject)this, 3, 3);
        }
        return this.resources;
    }

    @Override
    public Repository getRepository() {
        if (this.eContainerFeatureID() != 4) {
            return null;
        }
        return (Repository)this.eContainer();
    }

    public NotificationChain basicSetRepository(Repository newRepository, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newRepository, 4, msgs);
        return msgs;
    }

    @Override
    public void setRepository(Repository newRepository) {
        if (newRepository != this.eInternalContainer() || this.eContainerFeatureID() != 4 && newRepository != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)((EObject)newRepository))) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newRepository != null) {
                msgs = ((InternalEObject)newRepository).eInverseAdd((InternalEObject)this, 0, Repository.class, msgs);
            }
            if ((msgs = this.basicSetRepository(newRepository, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newRepository, (Object)newRepository));
        }
    }

    @Override
    public EList<Instance> getAllInstances(EClass eClass) {
        UniqueEList instances = new UniqueEList();
        for (Type type : this.getTypes()) {
            if (!eClass.isSuperTypeOf(type.getEClass())) continue;
            instances.addAll(type.getInstances());
        }
        return instances;
    }

    @Override
    public EList<Instance> getInstances(EClass eClass) {
        try {
            Type type = this.getType(eClass);
            return new UniqueEList(type.getInstances());
        }
        catch (NullPointerException e) {
            return new UniqueEList();
        }
    }

    @Override
    public Type getType(EClass eClass) {
        for (Type type : this.getTypes()) {
            if (type.getEClass() != eClass) continue;
            return type;
        }
        return null;
    }

    @Override
    public Map<EClass, Set<Instance>> createExtentMap() {
        return new LazyExtentMap(this);
    }

    @Override
    public Instance newInstance(EClass eClass) {
        Type type = this.getCreateType(eClass);
        return type.newInstance();
    }

    Type getCreateType(EClass eClass) {
        Type type = this.getType(eClass);
        if (type == null) {
            type = MigrationFactory.eINSTANCE.createType();
            type.setEClass(eClass);
            this.getTypes().add((Object)type);
        }
        return type;
    }

    @Override
    public void delete(Instance instance) {
        for (EReference reference : instance.getEClass().getEAllReferences()) {
            if (!reference.isContainment()) continue;
            if (reference.isMany()) {
                List children = (List)instance.get((EStructuralFeature)reference);
                for (Instance child : children) {
                    this.delete(child);
                }
                continue;
            }
            Instance child = (Instance)instance.get((EStructuralFeature)reference);
            if (child == null) continue;
            this.delete(child);
        }
        this.remove(instance);
    }

    private void remove(Instance instance) {
        Type type = instance.getType();
        for (Slot slot : new ArrayList<Slot>((Collection<Slot>)instance.getSlots())) {
            instance.unset(slot.getEFeature());
        }
        for (ReferenceSlot referenceSlot : new ArrayList<ReferenceSlot>((Collection<ReferenceSlot>)instance.getReferences())) {
            referenceSlot.getInstance().remove((EStructuralFeature)referenceSlot.getEReference(), (Object)instance);
        }
        this.removeDeleteType(type, instance);
    }

    void removeDeleteType(Type type, Instance instance) {
        type.getInstances().remove((Object)instance);
        if (type.getInstances().isEmpty()) {
            this.getTypes().remove((Object)type);
        }
    }

    @Override
    public void validate() throws MigrationException {
        BasicDiagnostic chain = new BasicDiagnostic();
        for (ModelResource modelResource : this.getResources()) {
            for (Instance root : modelResource.getRootInstances()) {
                root.validate((DiagnosticChain)chain);
            }
        }
        if (chain.getSeverity() != 0) {
            throw new MigrationException(new DiagnosticException("Model not valid", (Diagnostic)chain));
        }
    }

    @Override
    public void checkConformance() throws MigrationException {
        Diagnostician diagnostician = new Diagnostician(){

            public String getObjectLabel(EObject object) {
                if (object instanceof Instance) {
                    Instance instance = (Instance)object;
                    return "Instance of type \"" + instance.getEClass().getName() + "\"";
                }
                if (object instanceof ReferenceSlot) {
                    ReferenceSlot referenceSlot = (ReferenceSlot)object;
                    return "Reference \"" + referenceSlot.getEReference().getName() + "\" of " + this.getObjectLabel((EObject)referenceSlot.getInstance());
                }
                if (object instanceof AttributeSlot) {
                    AttributeSlot referenceSlot = (AttributeSlot)object;
                    return "Attribute \"" + referenceSlot.getEAttribute().getName() + "\" of " + this.getObjectLabel((EObject)referenceSlot.getInstance());
                }
                return super.getObjectLabel(object);
            }
        };
        Diagnostic diagnostic = diagnostician.validate((EObject)this);
        if (diagnostic.getSeverity() != 0) {
            throw new MigrationException(new DiagnosticException("Model inconsistent", diagnostic));
        }
    }

    @Override
    public void commit() throws MigrationException {
        this.getMetamodel().validate();
        this.checkConformance();
        this.validate();
    }

    @Override
    public EList<Instance> getAllInstances(String className) {
        EClass eClass = this.checkAndGetClass(className);
        return this.getAllInstances(eClass);
    }

    @Override
    public EList<Instance> getInstances(String className) {
        EClass eClass = this.checkAndGetClass(className);
        return this.getInstances(eClass);
    }

    private EClass checkAndGetClass(String className) {
        EClass eClass = this.getMetamodel().getEClass(className);
        if (eClass == null) {
            throw new IllegalArgumentException("Class " + className + " not found.");
        }
        return eClass;
    }

    @Override
    public Instance newInstance(String className) {
        EClass eClass = this.checkAndGetClass(className);
        return this.newInstance(eClass);
    }

    @Override
    public ModelResource newResource(URI uri) {
        ModelResource resource = MigrationFactory.eINSTANCE.createModelResource();
        resource.setUri(uri);
        this.getResources().add((Object)resource);
        return resource;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getTypes()).basicAdd((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getResources()).basicAdd((Object)otherEnd, msgs);
            }
            case 4: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetRepository((Repository)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getTypes()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getResources()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return this.basicSetRepository(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 4: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 0, Repository.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getMetamodel();
                }
                return this.basicGetMetamodel();
            }
            case 1: {
                return this.getTypes();
            }
            case 2: {
                return this.isReflection();
            }
            case 3: {
                return this.getResources();
            }
            case 4: {
                return this.getRepository();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setMetamodel((Metamodel)newValue);
                return;
            }
            case 1: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setReflection((Boolean)newValue);
                return;
            }
            case 3: {
                this.getResources().clear();
                this.getResources().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setRepository((Repository)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setMetamodel(null);
                return;
            }
            case 1: {
                this.getTypes().clear();
                return;
            }
            case 2: {
                this.setReflection(false);
                return;
            }
            case 3: {
                this.getResources().clear();
                return;
            }
            case 4: {
                this.setRepository(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.metamodel != null;
            }
            case 1: {
                return this.types != null && !this.types.isEmpty();
            }
            case 2: {
                return this.reflection;
            }
            case 3: {
                return this.resources != null && !this.resources.isEmpty();
            }
            case 4: {
                return this.getRepository() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (reflection: ");
        result.append(this.reflection);
        result.append(')');
        return result.toString();
    }
}

