/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.swt.masterdetail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.ui.view.swt.RenderFailureView;
import org.eclipse.emf.ecp.view.internal.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextDisposeListener;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.label.model.VLabel;
import org.eclipse.emf.ecp.view.spi.label.model.VLabelFactory;
import org.eclipse.emf.ecp.view.spi.label.model.VLabelPackage;
import org.eclipse.emf.ecp.view.spi.model.LocalizationAdapter;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelLoadingProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelPropertiesHelper;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.layout.PageLayout;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailRenderingFunction;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailViewCache;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.emfforms.spi.view.annotation.model.VAnnotation;
import org.eclipse.emf.emfforms.spi.view.annotation.model.VAnnotationFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public class DetailViewManager
implements DetailViewCache {
    public static final String DETAIL_PROPERTY = "detail";
    private DetailViewCache cache = DetailViewCache.EMPTY;
    private final Set<ECPSWTView> views = new HashSet<ECPSWTView>();
    private final Composite detailStack;
    private final PageLayout detailLayout;
    private ECPSWTView currentDetailView;
    private boolean currentDetailViewReadOnly;
    private final VViewModelLoadingProperties detailProperties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
    private final Function<? super EObject, ? extends VView> detailViewFunction;
    private VView noDetails;
    private ECPSWTView renderedNoDetails;
    private String noDetailMessage;
    private boolean disposed;

    public DetailViewManager(Composite parent) {
        this(parent, null);
    }

    public DetailViewManager(Composite parent, Function<? super EObject, ? extends VView> detailView) {
        this.detailStack = new Composite(parent, 0);
        this.detailLayout = new PageLayout(this.detailStack);
        this.detailProperties.addNonInheritableProperty(DETAIL_PROPERTY, (Object)true);
        this.detailViewFunction = detailView != null ? detailView : __ -> null;
        this.detailStack.addDisposeListener((DisposeListener & Serializable)__ -> this.dispose());
    }

    public void dispose() {
        this.disposed = true;
        this.disposeViews();
        if (this.renderedNoDetails != null) {
            this.renderedNoDetails.dispose();
        }
        if (this.currentDetailView != null) {
            this.currentDetailView.dispose();
            this.setCurrentDetail(null, false);
        }
        this.detailStack.dispose();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void disposeViews() {
        ArrayList<ECPSWTView> toDispose = new ArrayList<ECPSWTView>(this.views);
        this.views.clear();
        toDispose.forEach(ECPSWTView::dispose);
    }

    public Control getDetailContainer() {
        return this.detailStack;
    }

    public void setCache(DetailViewCache cache) {
        if (cache != this.cache && this.cache != null) {
            this.disposeViews();
        }
        this.cache = cache != null ? cache : DetailViewCache.EMPTY;
    }

    public ECPSWTView activate(EObject eObject) {
        this.cacheCurrentDetail(false);
        ECPSWTView cached = this.cache.getCachedView(eObject);
        if (cached == null) {
            throw new IllegalStateException("not cached");
        }
        ViewModelContext context = cached.getViewModelContext();
        if (context.getDomainModel() != eObject) {
            context.changeDomainModel(eObject);
        }
        ECPSWTView result = this.render(context, (p, c) -> {
            throw new IllegalStateException("not cached");
        });
        return result;
    }

    public ECPSWTView render(ViewModelContext context, DetailRenderingFunction renderer) {
        ECPSWTView result;
        this.cacheCurrentDetail(false);
        EObject domainModel = context.getDomainModel();
        ECPSWTView eCPSWTView = result = this.isCached(domainModel) ? this.getCachedView(domainModel) : null;
        if (result == null) {
            try {
                result = renderer.render(this.detailStack, context);
            }
            catch (ECPRendererException e) {
                ReportService reportService = (ReportService)context.getService(ReportService.class);
                reportService.report((AbstractReport)new RenderingFailedReport(e));
                result = new RenderFailureView(this.detailStack, context, e);
            }
            context.registerDisposeListener((ViewModelContextDisposeListener)new ContextDisposeListener(result));
        } else {
            if (result.getViewModelContext().getDomainModel() != domainModel) {
                result.getViewModelContext().changeDomainModel(domainModel);
            }
            if (context != result.getViewModelContext()) {
                context.dispose();
            }
        }
        this.showDetail(result.getSWTControl());
        VElement detailVView = result.getViewModelContext().getViewModel();
        this.setCurrentDetail(result, detailVView.isEffectivelyReadonly() || !detailVView.isEffectivelyEnabled());
        this.views.remove(result);
        return result;
    }

    private void setCurrentDetail(ECPSWTView ecpView, boolean readOnly) {
        if (this.currentDetailView == ecpView) {
            return;
        }
        this.currentDetailView = ecpView;
        this.currentDetailViewReadOnly = readOnly;
    }

    private void showDetail(Control control) {
        this.detailLayout.showPage(control);
        Composite composite = this.detailStack;
        while (composite != null) {
            if (composite.getParent() instanceof ScrolledComposite) {
                ScrolledComposite scrollPane = (ScrolledComposite)composite.getParent();
                if (composite != scrollPane.getContent()) break;
                scrollPane.setMinSize(composite.computeSize(-1, -1));
                break;
            }
            composite = composite.getParent();
        }
    }

    public ECPSWTView render(ViewModelContext masterContext, VElement masterView, EObject object) {
        ECPSWTView result;
        this.cacheCurrentDetail(false);
        VView detail = this.getDetailView(object);
        boolean detailReadOnly = detail.isEffectivelyReadonly() || !detail.isEffectivelyEnabled();
        detail.setReadonly(detailReadOnly || !masterView.isEffectivelyEnabled() || masterView.isEffectivelyReadonly());
        if (this.isCached(object)) {
            result = this.activate(object);
            result.getViewModelContext().changeDomainModel(object);
        } else {
            ViewModelContext childContext = masterContext.getChildContext(object, masterView, detail, new ViewModelService[0]);
            result = this.render(childContext, ECPSWTViewRenderer.INSTANCE::render);
        }
        this.currentDetailViewReadOnly = detailReadOnly;
        return result;
    }

    public final ECPSWTView getCurrentDetail() {
        return this.currentDetailView;
    }

    public void cacheCurrentDetail() {
        this.cacheCurrentDetail(true);
    }

    private void cacheCurrentDetail(boolean showEmpty) {
        if (this.currentDetailView != null) {
            ECPSWTView ecpView = this.currentDetailView;
            this.setCurrentDetail(null, false);
            if (this.isDisposed()) {
                ecpView.dispose();
                showEmpty = true;
            } else if (!this.cacheView(ecpView)) {
                showEmpty = true;
            }
        }
        if (showEmpty && !this.isDisposed()) {
            this.showDetail(this.getNoDetailsControl().getSWTControl());
        }
    }

    public void setFocus() {
        if (this.currentDetailView != null && !this.currentDetailView.getSWTControl().isDisposed()) {
            this.currentDetailView.getSWTControl().setFocus();
        }
    }

    public VViewModelProperties getDetailProperties() {
        return this.detailProperties;
    }

    public VView getDetailView(ViewModelContext masterContext, EObject object) {
        return this.getDetailView(masterContext, object, null);
    }

    public VView getDetailView(ViewModelContext masterContext, EObject object, Consumer<? super VViewModelProperties> propertiesManipulator) {
        VElement viewModel = masterContext.getViewModel();
        VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)viewModel);
        if (propertiesManipulator != null) {
            propertiesManipulator.accept((VViewModelProperties)properties);
        }
        this.detailProperties.getNonInheritableProperties().map().forEach((arg_0, arg_1) -> ((VViewModelProperties)properties).addNonInheritableProperty(arg_0, arg_1));
        this.detailProperties.getInheritableProperties().map().forEach((arg_0, arg_1) -> ((VViewModelProperties)properties).addInheritableProperty(arg_0, arg_1));
        return ViewProviderHelper.getView((EObject)object, (VViewModelProperties)properties);
    }

    public VView getDetailView(EObject object) {
        return this.getDetailView(object, this.getDetailProperties());
    }

    public void setDetailReadOnly(boolean readOnly) {
        if (this.currentDetailView != null && !this.currentDetailView.getSWTControl().isDisposed()) {
            VElement currentDetailVView = this.currentDetailView.getViewModelContext().getViewModel();
            currentDetailVView.setReadonly(readOnly || this.currentDetailViewReadOnly);
        }
    }

    protected VView getDetailView(EObject object, VViewModelProperties properties) {
        VView result = this.detailViewFunction.apply((EObject)object);
        if (result != null) {
            result.setLoadingProperties((VViewModelProperties)EcoreUtil.copy((EObject)properties));
        } else {
            result = ViewProviderHelper.getView((EObject)object, (VViewModelProperties)properties);
            if (result == null) {
                result = this.getNoDetailView();
                result.setLoadingProperties((VViewModelProperties)EcoreUtil.copy((EObject)properties));
            }
        }
        return result;
    }

    protected VView getNoDetailView() {
        if (this.noDetails == null) {
            this.noDetails = VViewFactory.eINSTANCE.createView();
            this.noDetails.setUuid(Integer.toHexString(this.noDetails.hashCode()));
            VLabel label = VLabelFactory.eINSTANCE.createLabel();
            label.setUuid(Integer.toHexString(label.hashCode()));
            label.setName("%noDetails");
            VAnnotation annotation = VAnnotationFactory.eINSTANCE.createAnnotation();
            annotation.setKey(DETAIL_PROPERTY);
            annotation.setValue("noDetails");
            label.getAttachments().add((Object)annotation);
            this.noDetails.getChildren().add((Object)label);
        }
        VView result = (VView)EcoreUtil.copy((EObject)this.noDetails);
        if (this.noDetailMessage != null) {
            VLabel label = (VLabel)EcoreUtil.getObjectByType((Collection)result.getChildren(), (EClassifier)VLabelPackage.Literals.LABEL);
            label.setName(this.noDetailMessage);
        }
        result.eAdapters().add((Object)new LocalizationAdapter(){

            public String localize(String key) {
                return LocalizationServiceHelper.getString((Bundle)Activator.getDefault().getBundle(), (String)key);
            }
        });
        return result;
    }

    protected ECPSWTView getNoDetailsControl() {
        if (this.renderedNoDetails == null) {
            VView view = this.getNoDetailView();
            ViewModelContext context = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, (EObject)view);
            try {
                this.renderedNoDetails = ECPSWTViewRenderer.INSTANCE.render(this.detailStack, context);
            }
            catch (ECPRendererException e) {
                this.renderedNoDetails = new RenderFailureView(this.detailStack, context, e);
            }
        }
        return this.renderedNoDetails;
    }

    public Composite layoutDetailParent(Composite composite) {
        FillLayout layout = new FillLayout(512);
        GridLayout gridLayout = new GridLayout();
        layout.marginHeight = gridLayout.marginHeight;
        layout.marginWidth = gridLayout.marginWidth;
        composite.setLayout((Layout)layout);
        return composite;
    }

    public void setNoDetailMessage(String noDetailMessage) {
        this.noDetailMessage = noDetailMessage;
        if (this.renderedNoDetails != null) {
            boolean wasCurrent = this.detailLayout.getCurrentPage() == this.renderedNoDetails.getSWTControl();
            this.renderedNoDetails.dispose();
            this.renderedNoDetails = null;
            if (wasCurrent) {
                this.showDetail(this.getNoDetailsControl().getSWTControl());
            }
        }
    }

    @Override
    public boolean isCached(EObject selection) {
        return this.cache.isCached(selection);
    }

    @Override
    public ECPSWTView getCachedView(EObject selection) {
        return this.cache.getCachedView(selection);
    }

    @Override
    public boolean cacheView(ECPSWTView ecpView) {
        Control control = ecpView.getSWTControl();
        boolean result = this.cache.cacheView(ecpView);
        if (result && !control.isDisposed()) {
            this.views.add(ecpView);
        }
        return result;
    }

    private final class ContextDisposeListener
    implements ViewModelContextDisposeListener {
        private final ECPSWTView ecpView;

        ContextDisposeListener(ECPSWTView ecpView) {
            this.ecpView = ecpView;
        }

        public void contextDisposed(ViewModelContext viewModelContext) {
            this.ecpView.dispose();
            if (this.ecpView == DetailViewManager.this.currentDetailView) {
                DetailViewManager.this.cacheCurrentDetail();
            } else {
                DetailViewManager.this.views.remove(this.ecpView);
            }
        }
    }
}

