/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;

final class ISO_8859_1 {
    private ISO_8859_1() {
    }

    public static final class Writer {
        private CharSequence source;
        private int pos;
        private int end;

        public Writer configure(CharSequence source, int start, int end) {
            this.source = source;
            this.pos = start;
            this.end = end;
            return this;
        }

        public boolean write(Buffer destination) {
            while (this.pos < this.end) {
                char c = this.source.charAt(this.pos);
                if (c > '\u00ff') {
                    throw new IllegalArgumentException("Illegal ISO-8859-1 char: " + c);
                }
                if (!destination.hasRemaining()) {
                    return false;
                }
                destination.put((byte)c);
                ++this.pos;
            }
            return true;
        }

        public Writer reset() {
            this.source = null;
            this.pos = -1;
            this.end = -1;
            return this;
        }
    }

    public static final class Reader {
        public void read(Buffer source, Appendable destination) {
            int len = source.remaining();
            for (int i = 0; i < len; ++i) {
                char c = (char)(source.get() & 0xFF);
                try {
                    destination.append(c);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error appending to the destination", e);
                }
            }
        }

        public Reader reset() {
            return this;
        }
    }
}

