/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.CalendarMonth;
import com.sun.webui.jsf.component.DateManager;
import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.converter.DateConverter;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.validator.DateInRangeValidator;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.validator.Validator;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class Calendar
extends Field
implements DateManager,
NamingContainer {
    private static final String DATE_PICKER_LINK_FACET = "datePickerLink";
    private static final String DATE_PICKER_LINK_ID = "_datePickerLink";
    private static final String DATE_PICKER_FACET = "datePicker";
    private static final String DATE_PICKER_ID = "_datePicker";
    public static final String PATTERN_ID = "_pattern";
    private DateConverter dateConverter = null;
    private String dateFormatPattern = null;
    private String dateFormatPatternHelp = null;
    private Date maxDate = null;
    private Date minDate = null;
    private TimeZone timeZone = null;

    public Calendar() {
        this.setRendererType("com.sun.webui.jsf.Calendar");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.Calendar";
    }

    public ImageHyperlink getDatePickerLink(FacesContext context) {
        ImageHyperlink datePickerLink;
        UIComponent component = this.getFacet(DATE_PICKER_LINK_FACET);
        if (component instanceof ImageHyperlink) {
            datePickerLink = (ImageHyperlink)component;
        } else {
            datePickerLink = new ImageHyperlink();
            this.getFacets().put(DATE_PICKER_LINK_FACET, datePickerLink);
        }
        datePickerLink.setId(DATE_PICKER_LINK_ID);
        datePickerLink.setAlign("middle");
        StringBuilder js = new StringBuilder();
        js.append("javascript: ").append(this.getJavaScriptObjectName(context)).append(".toggle(); return false;");
        datePickerLink.setOnClick(js.toString());
        return datePickerLink;
    }

    public CalendarMonth getDatePicker() {
        Object comp = this.getFacet(DATE_PICKER_FACET);
        if (comp == null || !(comp instanceof CalendarMonth)) {
            CalendarMonth datePicker = new CalendarMonth();
            datePicker.setPopup(true);
            datePicker.setId(DATE_PICKER_ID);
            this.getFacets().put(DATE_PICKER_FACET, datePicker);
            comp = datePicker;
        }
        ((CalendarMonth)((Object)comp)).setJavaScriptObjectName(this.getJavaScriptObjectName(FacesContext.getCurrentInstance()));
        return (CalendarMonth)((Object)comp);
    }

    public String getJavaScriptObjectName(FacesContext context) {
        return JavaScriptUtilities.getDomNode(this.getFacesContext(), (UIComponent)this);
    }

    public Converter getConverter() {
        Converter converter;
        Validator[] validators = this.getValidators();
        int len = validators.length;
        boolean found = false;
        for (int i = 0; i < len; ++i) {
            if (!(validators[i] instanceof DateInRangeValidator)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addValidator(new DateInRangeValidator());
        }
        if ((converter = super.getConverter()) == null) {
            if (this.dateConverter == null) {
                this.dateConverter = new DateConverter();
            }
            converter = this.dateConverter;
        }
        return converter;
    }

    @Override
    public String getReadOnlyValueString(FacesContext context) {
        if (this.getValue() == null) {
            return "-";
        }
        return super.getReadOnlyValueString(context);
    }

    @Override
    public DateFormat getDateFormat() {
        return this.getDatePicker().getDateFormat();
    }

    @Override
    public Date getFirstAvailableDate() {
        Date min = this.getMinDate();
        if (min == null) {
            java.util.Calendar calendar = this.getDatePicker().getCalendar();
            calendar.add(1, -100);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            min = calendar.getTime();
        }
        return min;
    }

    @Override
    public Date getLastAvailableDate() {
        Date max = this.getMaxDate();
        if (max == null) {
            Date min = this.getFirstAvailableDate();
            java.util.Calendar calendar = this.getDatePicker().getCalendar();
            calendar.setTime(min);
            calendar.add(1, 200);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            max = calendar.getTime();
        }
        return max;
    }

    @Override
    public String getPrimaryElementID(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    @Override
    public String getLabeledElementId(FacesContext context) {
        return this.getClientId(context).concat("_field");
    }

    @Override
    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public void setDateFormatPattern(String newDateFormatPattern) {
        this.dateFormatPattern = newDateFormatPattern;
        CalendarMonth dp = this.getDatePicker();
        dp.setDateFormatPattern(newDateFormatPattern);
    }

    public void setTimeZone(TimeZone newTimeZone) {
        this.timeZone = newTimeZone;
        CalendarMonth dp = this.getDatePicker();
        dp.setTimeZone(newTimeZone);
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    @Override
    public int getMaxLength() {
        return super.getMaxLength();
    }

    @Override
    public Object getText() {
        return super.getText();
    }

    @Override
    public boolean isTrim() {
        return super.isTrim();
    }

    @Override
    public ValueExpression getValueExpression(String name) {
        if (name.equals("selectedDate")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    @Override
    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("selectedDate")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    @Override
    public String getDateFormatPattern() {
        if (this.dateFormatPattern != null) {
            return this.dateFormatPattern;
        }
        ValueExpression vb = this.getValueExpression("dateFormatPattern");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public String getDateFormatPatternHelp() {
        if (this.dateFormatPatternHelp != null) {
            return this.dateFormatPatternHelp;
        }
        ValueExpression vb = this.getValueExpression("dateFormatPatternHelp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setDateFormatPatternHelp(String newDateFormatPatternHelp) {
        this.dateFormatPatternHelp = newDateFormatPatternHelp;
    }

    public Date getMaxDate() {
        if (this.maxDate != null) {
            return this.maxDate;
        }
        ValueExpression vb = this.getValueExpression("maxDate");
        if (vb != null) {
            return (Date)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setMaxDate(Date newMaxDate) {
        this.maxDate = newMaxDate;
    }

    public Date getMinDate() {
        if (this.minDate != null) {
            return this.minDate;
        }
        ValueExpression vb = this.getValueExpression("minDate");
        if (vb != null) {
            return (Date)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setMinDate(Date newMinDate) {
        this.minDate = newMinDate;
    }

    public Date getSelectedDate() {
        return (Date)this.getValue();
    }

    public void setSelectedDate(Date selectedDate) {
        this.setValue(selectedDate);
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        ValueExpression vb = this.getValueExpression("timeZone");
        if (vb != null) {
            return (TimeZone)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.dateFormatPattern = (String)values[1];
        this.dateFormatPatternHelp = (String)values[2];
        this.maxDate = (Date)values[3];
        this.minDate = (Date)values[4];
        this.timeZone = (TimeZone)values[5];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.dateFormatPattern, this.dateFormatPatternHelp, this.maxDate, this.minDate, this.timeZone};
        return values;
    }
}

