/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectConsumer;
import com.sun.messaging.jms.ra.DirectMessageListener;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.EndpointConsumer;
import com.sun.messaging.jms.ra.ResourceAdapter;
import jakarta.jms.JMSException;
import jakarta.jms.Topic;
import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.util.Vector;

public class ConcurrentEndpointConsumer
extends EndpointConsumer {
    private static final int numConcurrentConsumers = 20;
    private Vector<DirectConnection> connections = new Vector(20);

    public ConcurrentEndpointConsumer(ResourceAdapter ra, MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        super(ra, endpointFactory, spec);
    }

    @Override
    protected void startDirectConsumer() throws NotSupportedException {
        DirectConnection dc2 = null;
        for (DirectConnection dc2 : this.connections) {
            try {
                dc2.start();
            }
            catch (JMSException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void stopDirectConsumer() throws Exception {
    }

    @Override
    protected void createDirectMessageConsumer() throws NotSupportedException {
        try {
            int i = 0;
            while (true) {
                if (i < 20) {
                    DirectConnection dc = (DirectConnection)this.dcf._createConnection(this.username, this.password);
                    this.connections.add(dc);
                    DirectSession ds = (DirectSession)dc.createSession(false, 2);
                    DirectConsumer msgConsumer = (DirectConsumer)(this.isDurable ? ds.createDurableSubscriber((Topic)this.destination, this.subscriptionName, this.selector, false) : ds.createConsumer(this.destination, this.selector));
                    DirectMessageListener dMsgListener = new DirectMessageListener(this, this.endpointFactory, dc, this.onMessageMethod, this.isDeliveryTransacted, this.exRedeliveryAttempts, this.noAckDelivery);
                    msgConsumer.setMessageListener(dMsgListener);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
    }
}

