/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.acc.config.ClientContainer;
import org.glassfish.appclient.client.acc.config.Property;
import org.glassfish.appclient.client.acc.config.Security;
import org.glassfish.appclient.client.acc.config.TargetServer;

public class TargetServerHelper {
    private static int DEFAULT_ENDPOINT_PORT = Integer.parseInt("3700");
    private static final String SSL_PROPERTY_NAME = "ssl";
    private static final String COMMA = ",";
    private static final String PLUS = "+";

    public static TargetServer[] targetServers(ClientContainer clientContainer, String commandOptionValue) throws UserError {
        List<TargetServer> result = commandOptionValue != null ? TargetServerHelper.selectEndpointsFromCommandLine(commandOptionValue) : TargetServerHelper.selectEndpointsFromConfig(clientContainer);
        return result.toArray(new TargetServer[result.size()]);
    }

    private static List<TargetServer> selectEndpointsFromConfig(ClientContainer cc) {
        boolean isGlobalSSL = false;
        for (Property p : cc.getProperty()) {
            if (!p.getName().equals(SSL_PROPERTY_NAME)) continue;
            isGlobalSSL = Boolean.parseBoolean(p.getValue());
        }
        ArrayList<TargetServer> endpoints = new ArrayList<TargetServer>();
        endpoints.addAll(cc.getTargetServer());
        for (TargetServer ts : endpoints) {
            if (!isGlobalSSL || ts.getSecurity() != null) continue;
            Security sec = new Security();
            ts.setSecurity(sec);
        }
        return endpoints;
    }

    private static List<TargetServer> selectEndpointsFromCommandLine(String serverText) {
        return TargetServerHelper.endpointsFromListList(serverText);
    }

    private static List<TargetServer> endpointsFromListList(String endpointsText) {
        ArrayList<TargetServer> result = new ArrayList<TargetServer>();
        String delimiter = endpointsText.contains(PLUS) ? PLUS : COMMA;
        for (String endpointText : endpointsText.split(delimiter)) {
            result.add(TargetServerHelper.endpointFromHostColonPort(endpointText));
        }
        return result;
    }

    private static TargetServer endpointFromHostColonPort(String endpointText) {
        int port;
        String host;
        int colon = endpointText.indexOf(58);
        if (colon == -1) {
            host = endpointText;
            port = DEFAULT_ENDPOINT_PORT;
        } else {
            host = endpointText.substring(0, colon);
            port = Integer.parseInt(endpointText.substring(colon + 1));
        }
        return new TargetServer(host, Integer.valueOf(port));
    }
}

