/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xwss;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import com.sun.xml.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.util.ServletContextUtil;
import com.sun.xml.wss.util.WSSServletContextFacade;
import com.sun.xml.xwss.XWSSClientTube;
import com.sun.xml.xwss.XWSSServerTube;
import jakarta.xml.ws.WebServiceException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.namespace.QName;

public class XWSSTubelineAssemblerFactory
extends TubelineAssemblerFactory {
    private static final String addrVersionClass = "com.sun.xml.ws.api.addressing.AddressingVersion";
    private static final boolean disable = Boolean.getBoolean("DISABLE_XWSS_SECURITY");

    @Override
    public TubelineAssembler doCreate(BindingID bindingId) {
        return new XWSSTubelineAssembler(bindingId);
    }

    private static class XWSSTubelineAssembler
    implements TubelineAssembler {
        private final BindingID bindingId;

        XWSSTubelineAssembler(BindingID bindingId) {
            this.bindingId = bindingId;
        }

        @Override
        @NotNull
        public Tube createClient(@NotNull ClientTubeAssemblerContext context) {
            Tube p = context.createTransportTube();
            if (XWSSTubelineAssembler.isSecurityConfigPresent(context)) {
                p = XWSSTubelineAssembler.initializeXWSSClientTube(context.getWsdlModel(), context.getService(), context.getBinding(), p);
            }
            p = context.createClientMUTube(p);
            p = context.createHandlerTube(p);
            if (this.isAddressingEnabled(context.getWsdlModel(), context.getBinding())) {
                p = context.createWsaTube(p);
            }
            return p;
        }

        @Override
        @NotNull
        public Tube createServer(@NotNull ServerTubeAssemblerContext context) {
            Tube p = context.getTerminalTube();
            p = context.createHandlerTube(p);
            p = context.createServerMUTube(p);
            p = context.createMonitoringTube(p);
            if (this.isAddressingEnabled(context.getWsdlModel(), context.getEndpoint().getBinding())) {
                p = context.createWsaTube(p);
            }
            if (XWSSTubelineAssembler.isSecurityConfigPresent(context)) {
                p = XWSSTubelineAssembler.initializeXWSSServerTube(context.getEndpoint(), context.getWsdlModel(), p);
            }
            return p;
        }

        private boolean isAddressingEnabled(WSDLPort port, WSBinding binding) {
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(XWSSTubelineAssemblerFactory.addrVersionClass);
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
            if (clazz != null) {
                try {
                    Method meth = clazz.getMethod("isEnabled", WSBinding.class);
                    Object result = meth.invoke(null, binding);
                    if (result instanceof Boolean) {
                        return (Boolean)result;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    throw new WebServiceException((Throwable)ex);
                }
            }
            return false;
        }

        private static boolean isSecurityConfigPresent(ClientTubeAssemblerContext context) {
            String configUrl = "META-INF/client_security_config.xml";
            URL url = SecurityUtil.loadFromClasspath(configUrl);
            if (url != null) {
                return true;
            }
            return !disable;
        }

        private static boolean isSecurityConfigPresent(ServerTubeAssemblerContext context) {
            QName serviceQName = context.getEndpoint().getServiceName();
            String serviceLocalName = serviceQName.getLocalPart();
            WSSServletContextFacade ctxt = ServletContextUtil.getServletContextFacade(context.getEndpoint());
            String serverName = "server";
            if (ctxt != null) {
                String serverConfig = "/WEB-INF/" + serverName + "_security_config.xml";
                URL url = ctxt.getResource(serverConfig);
                if (url == null) {
                    serverConfig = "/WEB-INF/" + serviceLocalName + "_security_config.xml";
                    url = ctxt.getResource(serverConfig);
                }
                return url != null;
            }
            String serverConfig = "META-INF/" + serverName + "_security_config.xml";
            URL url = SecurityUtil.loadFromClasspath(serverConfig);
            if (url == null) {
                serverConfig = "META-INF/" + serviceLocalName + "_security_config.xml";
                url = SecurityUtil.loadFromClasspath(serverConfig);
            }
            return url != null;
        }

        private static Tube initializeXWSSClientTube(WSDLPort prt, WSService svc, WSBinding bnd, Tube nextP) {
            return new XWSSClientTube(prt, svc, bnd, nextP);
        }

        private static Tube initializeXWSSServerTube(WSEndpoint epoint, WSDLPort prt, Tube nextP) {
            return new XWSSServerTube(epoint, prt, nextP);
        }
    }
}

