/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.jwt.jwt;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.jwt.ClaimValue;

public class JWTInjectableType {
    private Type fullType;
    private Class<?> coreClass;
    private boolean optional;
    private boolean claimValue;
    private Function<JsonValue, Object> converter;

    public JWTInjectableType(Type fullType) {
        this.fullType = fullType;
        this.coreClass = (Class)fullType;
        this.installCoreConverter();
    }

    public JWTInjectableType(Type fullType, Class<?> coreClass) {
        this.fullType = fullType;
        this.coreClass = coreClass;
        this.installCoreConverter();
    }

    public JWTInjectableType(Type fullType, JWTInjectableType previous) {
        this.fullType = fullType;
        this.coreClass = previous.getCoreClass();
        this.optional = previous.isOptional() ? true : this.isTypeOptional(fullType);
        this.claimValue = this.isTypeClaimValue(fullType);
        this.installCoreConverter();
    }

    public Object convert(JsonValue value) {
        if (value == null) {
            return null;
        }
        return this.converter.apply(value);
    }

    public Type getFullType() {
        return this.fullType;
    }

    public Class<?> getCoreClass() {
        return this.coreClass;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isClaimValue() {
        return this.claimValue;
    }

    public String toString() {
        return "fullType: " + this.fullType + " coreClass: " + this.coreClass + " optional: " + this.optional + " claimValue: " + this.claimValue;
    }

    private boolean isTypeOptional(Type type) {
        return Optional.class.isAssignableFrom(this.getClassFromType(this.fullType));
    }

    private boolean isTypeClaimValue(Type type) {
        return ClaimValue.class.isAssignableFrom(this.getClassFromType(this.fullType));
    }

    private Class<?> getClassFromType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    private void installCoreConverter() {
        this.converter = this.coreClass == String.class ? e -> ((JsonString)e).getString() : (this.coreClass == Set.class ? e -> JWTInjectableType.convertToSet(e) : (this.coreClass == Long.class ? e -> ((JsonNumber)e).longValue() : (this.coreClass == Boolean.class ? e -> JWTInjectableType.convertToBoolean(e) : (this.coreClass == JsonArray.class ? e -> e instanceof JsonArray ? e : Json.createArrayBuilder().add(e).build() : e -> e))));
    }

    private static Set<String> convertToSet(JsonValue jsonValue) {
        if (jsonValue instanceof JsonArray) {
            return new HashSet(((JsonArray)jsonValue).getValuesAs(JsonString.class)).stream().map(t -> t.getString()).collect(Collectors.toSet());
        }
        return Collections.singleton(((JsonString)jsonValue).getString());
    }

    private static boolean convertToBoolean(JsonValue jsonValue) {
        if (jsonValue instanceof JsonString) {
            return Boolean.parseBoolean(((JsonString)jsonValue).getString());
        }
        return Boolean.parseBoolean(jsonValue.toString());
    }
}

