/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.ServiceInitializerFilter;
import java.util.logging.Logger;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.config.GenericGrizzlyListener;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.hk2.api.ServiceLocator;

public class ServiceInitializerListener
extends GenericGrizzlyListener {
    private final Logger logger;
    private final GrizzlyService grizzlyService;
    private final NetworkListener networkListener;

    public ServiceInitializerListener(GrizzlyService grizzlyService, NetworkListener networkListener, Logger logger) {
        this.grizzlyService = grizzlyService;
        this.networkListener = networkListener;
        this.logger = logger;
    }

    public NetworkListener getNetworkListener() {
        return this.networkListener;
    }

    protected void configureTransport(NetworkListener networkListener, Transport transportConfig, FilterChainBuilder filterChainBuilder) {
        this.transport = this.configureDefaultThreadPoolConfigs((NIOTransport)TCPNIOTransportBuilder.newInstance().build());
        int acceptorThreads = transportConfig != null ? Integer.parseInt(transportConfig.getAcceptorThreads()) : 1;
        this.transport.setSelectorRunnersCount(acceptorThreads);
        this.transport.getKernelThreadPoolConfig().setPoolName(networkListener.getName() + "-kernel");
        if (acceptorThreads > 0) {
            this.transport.getKernelThreadPoolConfig().setCorePoolSize(acceptorThreads).setMaxPoolSize(acceptorThreads);
        }
        this.rootFilterChain = FilterChainBuilder.stateless().build();
        this.transport.setProcessor((Processor)this.rootFilterChain);
        this.transport.setIOStrategy((IOStrategy)SameThreadIOStrategy.getInstance());
    }

    protected void configureProtocol(ServiceLocator habitat, NetworkListener networkListener, Protocol protocol, FilterChainBuilder filterChainBuilder) {
        filterChainBuilder.add((Filter)new ServiceInitializerFilter(this, this.grizzlyService.getServiceLocator(), this.logger));
    }

    protected void configureThreadPool(ServiceLocator habitat, NetworkListener networkListener, ThreadPool threadPool) {
        this.transport.setWorkerThreadPoolConfig(null);
    }
}

