/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.agg.Aggregator;

public class VarPAggregator<V extends Number>
implements Aggregator<V, Double, VarPAggregator<V>>,
Externalizable {
    private static final long serialVersionUID = 239794626052067761L;
    protected Sums sums;
    protected int count;

    @Override
    public void init() {
        this.sums = new Sums();
        this.count = 0;
    }

    @Override
    public void accumulate(V v) {
        double d = ((Number)v).doubleValue();
        this.sums.x += d;
        this.sums.x2 += Math.pow(d, 2.0);
        ++this.count;
    }

    @Override
    public void merge(VarPAggregator<V> varPAggregator) {
        this.sums.x += varPAggregator.sums.x;
        this.sums.x2 += varPAggregator.sums.x2;
        this.count += varPAggregator.count;
    }

    protected Double computeVar() {
        if (this.count == 0) {
            return null;
        }
        return this.sums.x2 / (double)this.count - Math.pow(this.sums.x / (double)this.count, 2.0);
    }

    @Override
    public Double terminate() {
        return this.computeVar();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.count = objectInput.readInt();
        this.sums = (Sums)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.count);
        objectOutput.writeObject(this.sums);
    }

    public static class Sums {
        double x = 0.0;
        double x2 = 0.0;
    }
}

