/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.tag.common.core;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.glassfish.wasp.taglibs.standard.resources.Resources;
import org.glassfish.wasp.taglibs.standard.tag.common.core.NullAttributeException;
import org.glassfish.wasp.taglibs.standard.tag.common.core.ParamParent;
import org.glassfish.wasp.taglibs.standard.tag.common.core.ParamSupport;
import org.glassfish.wasp.taglibs.standard.tag.common.core.Util;

public abstract class ImportSupport
extends BodyTagSupport
implements TryCatchFinally,
ParamParent {
    public static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String url;
    protected String context;
    protected String charEncoding;
    private String var;
    private int scope;
    private String varReader;
    private Reader r;
    private boolean isAbsoluteUrl;
    private ParamSupport.ParamManager params;
    private String urlWithParams;

    public ImportSupport() {
        this.init();
    }

    private void init() {
        this.urlWithParams = null;
        this.charEncoding = null;
        this.context = null;
        this.varReader = null;
        this.var = null;
        this.url = null;
        this.params = null;
        this.scope = 1;
    }

    public int doStartTag() throws JspException {
        if (!(this.context == null || this.context.startsWith("/") && this.url.startsWith("/"))) {
            throw new JspTagException(Resources.getMessage("IMPORT_BAD_RELATIVE"));
        }
        this.urlWithParams = null;
        this.params = new ParamSupport.ParamManager();
        if (this.url == null || this.url.equals("")) {
            throw new NullAttributeException("import", "url");
        }
        this.isAbsoluteUrl = this.isAbsoluteUrl();
        try {
            if (this.varReader != null) {
                this.r = this.acquireReader();
                this.pageContext.setAttribute(this.varReader, (Object)this.r);
            }
        }
        catch (IOException ex) {
            throw new JspTagException(ex.toString(), (Throwable)ex);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.varReader == null) {
                if (this.var != null) {
                    this.pageContext.setAttribute(this.var, (Object)this.acquireString(), this.scope);
                } else {
                    this.pageContext.getOut().print(this.acquireString());
                }
            }
            return 6;
        }
        catch (IOException ex) {
            throw new JspTagException(ex.toString(), (Throwable)ex);
        }
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        try {
            if (this.varReader != null) {
                if (this.r != null) {
                    this.r.close();
                }
                this.pageContext.removeAttribute(this.varReader, 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void release() {
        this.init();
        super.release();
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setVarReader(String varReader) {
        this.varReader = varReader;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    @Override
    public void addParameter(String name, String value) {
        this.params.addParameter(name, value);
    }

    private String acquireString() throws IOException, JspException {
        if (this.isAbsoluteUrl) {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader r = new BufferedReader(this.acquireReader());){
                int i;
                while ((i = r.read()) != -1) {
                    sb.append((char)i);
                }
            }
            return sb.toString();
        }
        if (!(this.pageContext.getRequest() instanceof HttpServletRequest) || !(this.pageContext.getResponse() instanceof HttpServletResponse)) {
            throw new JspTagException(Resources.getMessage("IMPORT_REL_WITHOUT_HTTP"));
        }
        ServletContext c = null;
        Object targetUrl = this.targetUrl();
        if (this.context != null) {
            c = this.pageContext.getServletContext().getContext(this.context);
        } else {
            c = this.pageContext.getServletContext();
            if (!((String)targetUrl).startsWith("/")) {
                String sp = ((HttpServletRequest)this.pageContext.getRequest()).getServletPath();
                targetUrl = sp.substring(0, sp.lastIndexOf(47)) + "/" + (String)targetUrl;
            }
        }
        if (c == null) {
            throw new JspTagException(Resources.getMessage("IMPORT_REL_WITHOUT_DISPATCHER", this.context, targetUrl));
        }
        RequestDispatcher rd = c.getRequestDispatcher(ImportSupport.stripSession((String)targetUrl));
        if (rd == null) {
            throw new JspTagException(ImportSupport.stripSession((String)targetUrl));
        }
        ImportResponseWrapper irw = new ImportResponseWrapper(this.pageContext);
        try {
            rd.include(this.pageContext.getRequest(), (ServletResponse)irw);
        }
        catch (IOException ex) {
            throw new JspException((Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw new JspException((Throwable)ex);
        }
        catch (ServletException ex) {
            Throwable rc = ex.getRootCause();
            if (rc == null) {
                throw new JspException((Throwable)ex);
            }
            throw new JspException(rc);
        }
        if (irw.getStatus() < 200 || irw.getStatus() > 299) {
            throw new JspTagException(irw.getStatus() + " " + ImportSupport.stripSession((String)targetUrl));
        }
        return irw.getString();
    }

    private Reader acquireReader() throws IOException, JspException {
        if (!this.isAbsoluteUrl) {
            return new StringReader(this.acquireString());
        }
        String target = this.targetUrl();
        try {
            int status;
            String charSet;
            URL u = new URL(target);
            URLConnection uc = u.openConnection();
            InputStream i = uc.getInputStream();
            InputStreamReader r = null;
            if (this.charEncoding != null && !this.charEncoding.equals("")) {
                charSet = this.charEncoding;
            } else {
                String contentType = uc.getContentType();
                if (contentType != null) {
                    charSet = Util.getContentTypeAttribute(contentType, "charset");
                    if (charSet == null) {
                        charSet = DEFAULT_ENCODING;
                    }
                } else {
                    charSet = DEFAULT_ENCODING;
                }
            }
            try {
                r = new InputStreamReader(i, charSet);
            }
            catch (Exception ex) {
                r = new InputStreamReader(i, DEFAULT_ENCODING);
            }
            if (uc instanceof HttpURLConnection && ((status = ((HttpURLConnection)uc).getResponseCode()) < 200 || status > 299)) {
                throw new JspTagException(status + " " + target);
            }
            return r;
        }
        catch (IOException ex) {
            throw new JspException(Resources.getMessage("IMPORT_ABS_ERROR", target, ex), (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw new JspException(Resources.getMessage("IMPORT_ABS_ERROR", target, ex), (Throwable)ex);
        }
    }

    private String targetUrl() {
        if (this.urlWithParams == null) {
            this.urlWithParams = this.params.aggregateParams(this.url);
        }
        return this.urlWithParams;
    }

    private boolean isAbsoluteUrl() throws JspTagException {
        return ImportSupport.isAbsoluteUrl(this.url);
    }

    public static boolean isAbsoluteUrl(String url) {
        if (url == null) {
            return false;
        }
        int colonPos = url.indexOf(":");
        if (colonPos == -1) {
            return false;
        }
        for (int i = 0; i < colonPos; ++i) {
            if (VALID_SCHEME_CHARS.indexOf(url.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String stripSession(String url) {
        int sessionStart;
        StringBuilder u = new StringBuilder(url);
        while ((sessionStart = u.toString().indexOf(";jsessionid=")) != -1) {
            int sessionEnd = u.toString().indexOf(";", sessionStart + 1);
            if (sessionEnd == -1) {
                sessionEnd = u.toString().indexOf("?", sessionStart + 1);
            }
            if (sessionEnd == -1) {
                sessionEnd = u.length();
            }
            u.delete(sessionStart, sessionEnd);
        }
        return u.toString();
    }

    private class ImportResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter sw;
        private ByteArrayOutputStream bos;
        private ServletOutputStream sos;
        private boolean isWriterUsed;
        private boolean isStreamUsed;
        private int status;
        private PageContext pageContext;

        public ImportResponseWrapper(PageContext pageContext) {
            super((HttpServletResponse)pageContext.getResponse());
            this.sw = new StringWriter();
            this.bos = new ByteArrayOutputStream();
            this.sos = new ServletOutputStream(){

                public boolean isReady() {
                    return false;
                }

                public void setWriteListener(WriteListener writeListener) {
                }

                public void write(int b) throws IOException {
                    ImportResponseWrapper.this.bos.write(b);
                }

                public void flush() throws IOException {
                    ImportResponseWrapper.this.pageContext.getOut().write(ImportResponseWrapper.this.getString());
                    ImportResponseWrapper.this.bos.reset();
                }
            };
            this.status = 200;
            this.pageContext = pageContext;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.isStreamUsed) {
                throw new IllegalStateException(Resources.getMessage("IMPORT_ILLEGAL_STREAM"));
            }
            this.isWriterUsed = true;
            return new PrintWriter(this.sw);
        }

        public ServletOutputStream getOutputStream() {
            if (this.isWriterUsed) {
                throw new IllegalStateException(Resources.getMessage("IMPORT_ILLEGAL_WRITER"));
            }
            this.isStreamUsed = true;
            return this.sos;
        }

        public void setContentType(String x) {
        }

        public void setLocale(Locale x) {
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public String getString() throws UnsupportedEncodingException {
            if (this.isWriterUsed) {
                return this.sw.toString();
            }
            if (this.isStreamUsed) {
                if (ImportSupport.this.charEncoding != null && !ImportSupport.this.charEncoding.equals("")) {
                    return this.bos.toString(ImportSupport.this.charEncoding);
                }
                return this.bos.toString(ImportSupport.DEFAULT_ENCODING);
            }
            return "";
        }
    }
}

