/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.cli.ServerLifeSignCheck;
import com.sun.enterprise.admin.servermgmt.cli.ServerLifeSignChecker;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.ServerDirs;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.api.admin.CommandException;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.glassfish.main.jdke.props.SystemProperties;
import org.glassfish.main.jul.formatter.OneLineFormatter;
import org.glassfish.main.jul.handler.GlassFishLogHandler;
import org.glassfish.main.jul.handler.GlassFishLogHandlerConfiguration;

public final class StartServerHelper {
    private static final LocalStringsImpl I18N = new LocalStringsImpl(StartServerHelper.class);
    private static final System.Logger LOG = System.getLogger(StartServerHelper.class.getName(), I18N.getBundle());
    private final boolean terse;
    private final GFLauncher launcher;
    private final File pidFile;
    private final GFLauncherInfo launchParams;
    private final List<HostAndPort> adminAddresses;
    private final ServerDirs serverDirs;
    private final String serverTitleAndName;
    private final ServerLifeSignCheck lifeSignCheck;

    public StartServerHelper(boolean terse, Duration timeout, ServerDirs serverDirs, GFLauncher launcher, ServerLifeSignCheck lifeSignCheck) throws GFLauncherException {
        this.terse = terse;
        this.launcher = launcher;
        this.launchParams = launcher.getParameters();
        this.serverTitleAndName = (this.launchParams.isDomain() ? "domain " : "instance ") + serverDirs.getServerName();
        this.adminAddresses = this.launchParams.getAdminAddresses();
        this.serverDirs = serverDirs;
        this.pidFile = serverDirs.getPidFile();
        this.lifeSignCheck = lifeSignCheck;
        if (launcher.getPidBeforeRestart() != null) {
            this.waitForParentToDie(launcher.getPidBeforeRestart(), timeout);
            this.configureLoggingOfRestart(serverDirs.getRestartLogFile());
        }
        StartServerHelper.checkFreeDebugPort(launcher.getDebugPort(), Duration.ofSeconds(10L), terse);
        StartServerHelper.checkFreeAdminPorts(this.launchParams.getAdminAddresses());
        this.deletePidFile();
    }

    public int talkWithUser() throws GFLauncherException, MiniXmlParserException {
        while (true) {
            int returnValue = this.launcher.getExitValue();
            switch (returnValue) {
                case 10: {
                    LOG.log(System.Logger.Level.INFO, "restart");
                    break;
                }
                case 11: {
                    LOG.log(System.Logger.Level.INFO, "restartChangeDebug", "on");
                    this.launchParams.setDebug(true);
                    break;
                }
                case 12: {
                    LOG.log(System.Logger.Level.INFO, "restartChangeDebug", "off");
                    this.launchParams.setDebug(false);
                    break;
                }
                default: {
                    return returnValue;
                }
            }
            SystemProperties.setProperty((String)"WALL_CLOCK_START", (String)Instant.now().toString(), (boolean)true);
            this.launcher.setup();
            this.launcher.launch();
        }
    }

    public String waitForServerStart(Duration timeout) throws CommandException {
        if (!this.terse && this.launcher.isSuspendEnabled()) {
            System.out.print("Debugging is configured to listen on port " + this.launcher.getDebugPort() + ". Server's JVM is set to suspend.");
        }
        ServerLifeSignChecker.GlassFishProcess glassFishProcess = ServerLifeSignChecker.GlassFishProcess.of(this.launcher.getProcess());
        ServerLifeSignChecker checker = new ServerLifeSignChecker(this.lifeSignCheck, this.pidFile, () -> this.adminAddresses, !this.terse);
        ServerLifeSignChecker.ServerLifeSigns signs = checker.watchStartup(glassFishProcess, timeout);
        String report = this.report(signs);
        if (signs.isError()) {
            throw new CommandException(report);
        }
        return report;
    }

    private String report(ServerLifeSignChecker.ServerLifeSigns signs) {
        String situationReport;
        StringBuilder report = new StringBuilder(2048);
        report.append('\n').append(signs.getSummary());
        if (signs.getSuggestion() != null) {
            report.append('\n').append(signs.getSuggestion());
        }
        report.append("\n  Location: ").append(this.serverDirs.getServerDir());
        report.append("\n  Log File: ").append(this.launcher.getLogFile());
        if (this.launcher.getDebugPort() != null) {
            report.append("\n  Debugging is configured to listen on port " + this.launcher.getDebugPort() + ".");
            if (this.launcher.isSuspendEnabled()) {
                report.append(" Server's JVM is set to suspend.");
            }
        }
        if ((situationReport = signs.getSituationReport()) != null) {
            report.append(signs.getSituationReport());
        }
        if (this.launcher.getPidBeforeRestart() != null || this.lifeSignCheck.isPrintServerOutput(signs.isError())) {
            report.append("\n\n").append(this.getProcessOutput());
        }
        return report.append('\n').toString();
    }

    private String getProcessOutput() {
        String output = this.launcher.getProcessStreamDrainer().getOutErrString();
        if (output == null) {
            return "Unfortunately the new process did not produce any output.";
        }
        return "The output of the process until we stopped watching:\n\n**********\n" + output + "\n**********";
    }

    private void configureLoggingOfRestart(File logFile) {
        GlassFishLogHandlerConfiguration cfg = new GlassFishLogHandlerConfiguration();
        cfg.setFormatterConfiguration((Formatter)new OneLineFormatter());
        if (logFile.isFile()) {
            logFile.renameTo(new File(logFile.getParent(), "restart.log_" + String.valueOf(LocalDateTime.now())));
        }
        cfg.setLogFile(logFile);
        cfg.setLevel(Level.ALL);
        cfg.setFlushFrequency(1);
        GlassFishLogHandler handler = new GlassFishLogHandler(cfg);
        Logger.getLogger("").addHandler((Handler)handler);
        Logger.getLogger("com.sun.enterprise.admin.cli").addHandler((Handler)handler);
    }

    private void waitForParentToDie(Long pid, Duration timeout) throws GFLauncherException {
        LOG.log(System.Logger.Level.INFO, () -> "Waiting for death of the parent process with the pid " + pid);
        if (!ProcessUtils.waitWhileIsAlive((long)pid, (Duration)timeout, (boolean)false)) {
            throw new GFLauncherException("Waited " + timeout.toSeconds() + " s for the server to die. Restart is not possible unless you kill it manually.");
        }
        LOG.log(System.Logger.Level.DEBUG, () -> "Parent process with PID " + pid + " is dead.");
    }

    private void deletePidFile() {
        if (this.pidFile.exists() && !this.pidFile.isFile()) {
            throw new IllegalStateException("The pid file " + String.valueOf(this.pidFile) + " is not a file!");
        }
        try {
            Files.delete(this.pidFile.toPath());
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't remove the pid file " + String.valueOf(this.pidFile), e);
        }
        LOG.log(System.Logger.Level.DEBUG, "The pid file {0} has been deleted.", this.pidFile);
    }

    public static String toHttpList(List<HostAndPort> endpoints) {
        return endpoints.stream().map(h -> (h.isSecure() ? "https://" : "http://") + h.getHost() + ":" + h.getPort()).collect(Collectors.joining(" "));
    }

    public static List<HostAndPort> parseCustomEndpoints(String customEndpoints) throws CommandException {
        if (customEndpoints == null || customEndpoints.isBlank()) {
            return List.of();
        }
        String[] strings = customEndpoints.strip().split(",");
        ArrayList<HostAndPort> endpoints = new ArrayList<HostAndPort>(strings.length);
        for (String string : strings) {
            try {
                HostAndPort endpoint;
                boolean secure = string.startsWith("https");
                boolean http = string.startsWith("http");
                String[] pair = string.replaceFirst("[a-z]+\\://", "").split(":");
                if (pair.length == 1) {
                    if (!http) {
                        throw new CommandException("Port is mandatory endpoints without explicit protocol: " + string);
                    }
                    int port = secure ? 443 : 80;
                    endpoint = new HostAndPort(pair[0], port, secure);
                } else if (pair.length == 2) {
                    endpoint = new HostAndPort(pair[0], Integer.parseInt(pair[1]), secure);
                } else {
                    throw new CommandException("Invalid customEndpoints value: " + string);
                }
                endpoints.add(endpoint);
            }
            catch (CommandException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CommandException("Invalid customEndpoints value: " + string, (Throwable)e);
            }
        }
        return endpoints;
    }

    private static void checkFreeDebugPort(Integer debugPort, Duration timeout, boolean terse) {
        if (debugPort == null || NetUtils.isPortFree((int)debugPort)) {
            return;
        }
        ProcessUtils.waitFor(() -> NetUtils.isPortFree((int)debugPort), (Duration)Duration.ofSeconds(10L), (boolean)terse);
    }

    private static void checkFreeAdminPorts(List<HostAndPort> endpoints) throws GFLauncherException {
        LOG.log(System.Logger.Level.DEBUG, "Checking if all admin ports are free.");
        for (HostAndPort endpoint : endpoints) {
            if (NetUtils.isPortFree((String)endpoint.getHost(), (int)endpoint.getPort())) continue;
            throw new GFLauncherException("There is a process already using the admin port " + endpoint.getPort() + " - it might be another instance of a GlassFish server.");
        }
    }
}

