/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.error.StandardException;

public class SYSSCHEMASRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSSCHEMAS";
    public static final int SYSSCHEMAS_COLUMN_COUNT = 3;
    public static final int SYSSCHEMAS_SCHEMAID = 1;
    public static final int SYSSCHEMAS_SCHEMANAME = 2;
    public static final int SYSSCHEMAS_SCHEMAAID = 3;
    protected static final int SYSSCHEMAS_INDEX1_ID = 0;
    protected static final int SYSSCHEMAS_INDEX2_ID = 1;
    private static final int[][] indexColumnPositions = new int[][]{{2}, {1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"80000022-00d0-fd77-3ed8-000a0a0b1900", "8000002a-00d0-fd77-3ed8-000a0a0b1900", "80000024-00d0-fd77-3ed8-000a0a0b1900", "80000026-00d0-fd77-3ed8-000a0a0b1900"};

    SYSSCHEMASRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(3, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        UUID uUID = null;
        String string2 = null;
        String string3 = null;
        if (tupleDescriptor != null) {
            SchemaDescriptor schemaDescriptor = (SchemaDescriptor)tupleDescriptor;
            string = schemaDescriptor.getSchemaName();
            uUID = schemaDescriptor.getUUID();
            if (uUID == null) {
                uUID = this.getUUIDFactory().createUUID();
                schemaDescriptor.setUUID(uUID);
            }
            string2 = uUID.toString();
            string3 = schemaDescriptor.getAuthorizationId();
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(3);
        execRow.setColumn(1, new SQLChar(string2));
        execRow.setColumn(2, new SQLVarchar(string));
        execRow.setColumn(3, new SQLVarchar(string3));
        return execRow;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(3);
        String string3 = dataValueDescriptor.getString();
        SchemaDescriptor schemaDescriptor = dataDescriptorGenerator.newSchemaDescriptor(string2, string3, uUID);
        return schemaDescriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getIdentifierColumn("SCHEMANAME", false), SystemColumnImpl.getIdentifierColumn("AUTHORIZATIONID", false)};
    }
}

