/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.nosql.metadata.reflection;

import jakarta.nosql.AttributeConverter;
import jakarta.nosql.Embeddable;
import jakarta.nosql.Entity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.mapping.metadata.ArrayFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.glassfish.main.jnosql.nosql.metadata.reflection.AbstractFieldMetadata;
import org.glassfish.main.jnosql.nosql.metadata.reflection.FieldReader;
import org.glassfish.main.jnosql.nosql.metadata.reflection.FieldWriter;

final class DefaultArrayFieldMetadata
extends AbstractFieldMetadata
implements ArrayFieldMetadata {
    private static final TypeReference<List<Object>> TYPE_SUPPLIER = new TypeReference<List<Object>>(){};
    private final Class<?> elementType;
    private final boolean entityField;
    private final boolean embeddableField;

    DefaultArrayFieldMetadata(MappingType type, Field field, String name, Class<?> elementType, Class<? extends AttributeConverter<?, ?>> converter, FieldReader reader, FieldWriter writer, String udt) {
        super(type, field, name, converter, reader, writer, udt);
        this.elementType = elementType;
        this.entityField = this.hasFieldAnnotation(Entity.class);
        this.embeddableField = this.hasFieldAnnotation(Embeddable.class);
    }

    @Override
    public Object value(Value value) {
        Objects.requireNonNull(value, "value is required");
        if (value.get() instanceof Iterable) {
            return ((List)value.get(TYPE_SUPPLIER)).toArray();
        }
        return Value.of(Collections.singletonList(value.get())).get(TYPE_SUPPLIER);
    }

    public boolean isId() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultArrayFieldMetadata that = (DefaultArrayFieldMetadata)o;
        return this.mappingType == that.mappingType && Objects.equals(this.field, that.field) && Objects.equals(this.elementType, that.elementType) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.mappingType, this.field, this.name, this.elementType);
    }

    public boolean isEmbeddable() {
        return this.isEmbeddableField() || this.isEntityField();
    }

    private boolean isEntityField() {
        return this.entityField;
    }

    private boolean isEmbeddableField() {
        return this.embeddableField;
    }

    private boolean hasFieldAnnotation(Class<? extends Annotation> annotation) {
        return this.elementType.getAnnotation(annotation) != null;
    }

    public Class<?> elementType() {
        return this.elementType;
    }

    public Object arrayInstance(Collection<?> collection) {
        Object array = Array.newInstance(this.elementType, collection.size());
        int index = 0;
        for (Object item : collection) {
            Array.set(array, index++, item);
        }
        return array;
    }
}

