/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.shared.common.error.StandardException;

public final class SQLTinyint
extends NumberDataType {
    static final int TINYINT_LENGTH = 1;
    private byte value;
    private boolean isnull;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLTinyint.class);

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    public SQLTinyint() {
        this.isnull = true;
    }

    public SQLTinyint(byte by) {
        this.value = by;
    }

    private SQLTinyint(byte by, boolean bl) {
        this.value = by;
        this.isnull = bl;
    }

    public SQLTinyint(Byte by) {
        this.isnull = by == null;
        if (!this.isnull) {
            this.value = by;
        }
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public byte getByte() {
        return this.value;
    }

    @Override
    public short getShort() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0;
    }

    @Override
    public String getString() {
        return this.isNull() ? null : Byte.toString(this.value);
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Object getObject() {
        return this.isNull() ? null : Byte.valueOf(this.value);
    }

    @Override
    public String getTypeName() {
        return "TINYINT";
    }

    @Override
    public int getTypeFormatId() {
        return 199;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.value);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readByte();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n;
        int n2 = this.getInt();
        if (n2 == (n = dataValueDescriptor.getInt())) {
            return 0;
        }
        if (n2 > n) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        return new SQLTinyint(this.value, this.isnull);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLTinyint();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.value = resultSet.getByte(n);
        this.isnull = bl && resultSet.wasNull();
    }

    @Override
    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, -6);
            return;
        }
        preparedStatement.setByte(n, this.value);
    }

    @Override
    public final void setInto(ResultSet resultSet, int n) throws SQLException, StandardException {
        resultSet.updateByte(n, this.value);
    }

    @Override
    public void setValue(String string) throws StandardException {
        if (string == null) {
            this.value = 0;
            this.isnull = true;
        } else {
            try {
                this.value = Byte.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    @Override
    public void setValue(byte by) {
        this.value = by;
        this.isnull = false;
    }

    @Override
    public void setValue(short s) throws StandardException {
        if (s > 127 || s < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        this.value = (byte)s;
        this.isnull = false;
    }

    @Override
    public void setValue(int n) throws StandardException {
        if (n > 127 || n < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        this.value = (byte)n;
        this.isnull = false;
    }

    @Override
    public void setValue(long l) throws StandardException {
        if (l > 127L || l < -128L) {
            throw StandardException.newException("22003", "TINYINT");
        }
        this.value = (byte)l;
        this.isnull = false;
    }

    @Override
    public void setValue(float f) throws StandardException {
        if ((f = NumberDataType.normalizeREAL(f)) > 127.0f || f < -128.0f) {
            throw StandardException.newException("22003", "TINYINT");
        }
        float f2 = (float)Math.floor(f);
        this.value = (byte)f2;
        this.isnull = false;
    }

    @Override
    public void setValue(double d) throws StandardException {
        if ((d = NumberDataType.normalizeDOUBLE(d)) > 127.0 || d < -128.0) {
            throw this.outOfRange();
        }
        double d2 = Math.floor(d);
        this.value = (byte)d2;
        this.isnull = false;
    }

    @Override
    public void setValue(boolean bl) {
        this.value = bl ? (byte)1 : 0;
        this.isnull = false;
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getByte());
    }

    @Override
    public int typePrecedence() {
        return 30;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() == dataValueDescriptor2.getByte());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() != dataValueDescriptor2.getByte());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() < dataValueDescriptor2.getByte());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() > dataValueDescriptor2.getByte());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() <= dataValueDescriptor2.getByte());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() >= dataValueDescriptor2.getByte());
    }

    @Override
    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLTinyint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n = numberDataValue.getByte() * numberDataValue2.getByte();
        numberDataValue3.setValue(n);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLTinyint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        byte by = numberDataValue2.getByte();
        if (by == 0) {
            throw StandardException.newException("22012", new Object[0]);
        }
        numberDataValue3.setValue(numberDataValue.getByte() % by);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLTinyint();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        byte by = this.getByte();
        numberDataValue.setValue((int)(-by));
        return numberDataValue;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Byte.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }
}

