/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.model;

import jakarta.faces.model.DataModel;
import jakarta.faces.model.DataModelEvent;
import jakarta.faces.model.DataModelListener;
import jakarta.faces.model.NoRowAvailableException;

public class ArrayDataModel<E>
extends DataModel<E> {
    private Object[] array;
    private int index = -1;

    public ArrayDataModel() {
        this(null);
    }

    public ArrayDataModel(E[] array) {
        this.setWrappedData(array);
    }

    @Override
    public boolean isRowAvailable() {
        return this.array != null && this.index >= 0 && this.index < this.array.length;
    }

    @Override
    public int getRowCount() {
        if (this.array == null) {
            return -1;
        }
        return this.array.length;
    }

    @Override
    public E getRowData() {
        if (this.array == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        return (E)this.array[this.index];
    }

    @Override
    public int getRowIndex() {
        return this.index;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.array == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this.index, rowData);
            int n = listeners.length;
            for (DataModelListener listener : listeners) {
                if (null == listener) continue;
                listener.rowSelected(event);
            }
        }
    }

    @Override
    public Object getWrappedData() {
        return this.array;
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.array = null;
            this.setRowIndex(-1);
        } else {
            this.array = (Object[])data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }
}

