/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.protocol;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;

public class CloseSequenceData {
    @NotNull
    private final String sequenceId;
    private final long lastMessageId;
    @Nullable
    private final AcknowledgementData acknowledgementData;

    public static Builder getBuilder(@NotNull String outboundSequenceId, long lastMessageId) {
        return new Builder(outboundSequenceId, lastMessageId);
    }

    private CloseSequenceData(@NotNull String sequenceId, long lastMessageId, @Nullable AcknowledgementData acknowledgementData) {
        assert (sequenceId != null);
        this.sequenceId = sequenceId;
        this.lastMessageId = lastMessageId;
        this.acknowledgementData = acknowledgementData;
    }

    @NotNull
    public String getSequenceId() {
        return this.sequenceId;
    }

    public long getLastMessageId() {
        return this.lastMessageId;
    }

    @Nullable
    public AcknowledgementData getAcknowledgementData() {
        return this.acknowledgementData;
    }

    public static class Builder {
        @NotNull
        private final String sequenceId;
        private final long lastMessageId;
        @Nullable
        private AcknowledgementData acknowledgementData;

        private Builder(String outboundSequenceId, long lastMessageId) {
            this.sequenceId = outboundSequenceId;
            this.lastMessageId = lastMessageId;
        }

        public Builder acknowledgementData(@Nullable AcknowledgementData acknowledgementData) {
            this.acknowledgementData = acknowledgementData;
            return this;
        }

        public CloseSequenceData build() {
            return new CloseSequenceData(this.sequenceId, this.lastMessageId, this.acknowledgementData);
        }
    }
}

