/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.admingui.common.servlet.DownloadServlet;
import org.glassfish.admingui.common.util.RestUtil;

public class ClientStubsContentSource
implements DownloadServlet.ContentSource {
    @Override
    public String getId() {
        return "ClientStubs";
    }

    @Override
    public InputStream getInputStream(DownloadServlet.Context ctx) {
        ctx.setAttribute("extension", "CLIENT-STUBS");
        HttpServletRequest request = (HttpServletRequest)ctx.getServletRequest();
        String appName = request.getParameter("appName");
        String restUrl = request.getParameter("restUrl");
        FileInputStream tmpFile = null;
        try {
            String endpoint = restUrl + "/applications/application/" + appName + "/get-client-stubs";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = new Date();
            HashMap<String, Object> attrsMap = new HashMap<String, Object>();
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = "client-stubs-" + appName + "-" + dateFormat.format(date) + ".zip";
            File file = new File(tempDir, fileName);
            attrsMap.put("localDir", file.getAbsolutePath());
            RestUtil.getRestRequestFromServlet(request, endpoint, attrsMap, true, true);
            tmpFile = new FileInputStream(file);
            file.delete();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        ctx.setAttribute("tmpFile", tmpFile);
        return tmpFile;
    }

    @Override
    public void cleanUp(DownloadServlet.Context ctx) {
        InputStream tmpFile = (InputStream)ctx.getAttribute("tmpFile");
        if (tmpFile != null) {
            try {
                tmpFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ctx.removeAttribute("tmpFile");
    }

    @Override
    public long getLastModified(DownloadServlet.Context context) {
        return -1L;
    }
}

