/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.v3.admin.RestartDomainCommand;
import com.sun.enterprise.v3.admin.commands.JVMInformation;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.base.RuntimeRoot;
import org.glassfish.admin.amx.base.ServerRuntime;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.mbean.ServerRuntimeImpl;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.util.AMXLoggerInfo;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandContextImpl;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.hk2.api.ServiceLocator;

public final class RuntimeRootImpl
extends AMXImplBase {
    private final ServiceLocator mHabitat = InjectedValues.getInstance().getHabitat();
    private static final String ADMIN_LISTENER_NAME = "admin-listener";

    public RuntimeRootImpl(ObjectName parent) {
        super(parent, RuntimeRoot.class);
    }

    public ObjectName[] getServerRuntime() {
        return this.getChildren(ServerRuntime.class);
    }

    @Override
    protected final void registerChildren() {
        super.registerChildren();
        ObjectName self = this.getObjectName();
        MBeanServer server = this.getMBeanServer();
        ObjectNameBuilder objectNames = new ObjectNameBuilder(server, self);
        ObjectName childObjectName = null;
        ServerRuntimeImpl mbean = null;
        childObjectName = objectNames.buildChildObjectName(ServerRuntime.class, AMXGlassfish.DEFAULT.dasName());
        mbean = new ServerRuntimeImpl(self);
        this.registerChild(mbean, childObjectName);
    }

    public void stopDomain() {
        ModulesRegistry registry = InjectedValues.getInstance().getModulesRegistry();
        Collection modules = registry.getModules("com.sun.enterprise.osgi-adapter");
        if (modules.size() == 1) {
            Module mgmtAgentModule = (Module)modules.iterator().next();
            mgmtAgentModule.stop();
        } else {
            AMXLoggerInfo.getLogger().warning("NCLS-COM-00046");
        }
        AMXLoggerInfo.getLogger().warning("NCLS-COM-00047");
        System.exit(0);
    }

    public void restartDomain() {
        ModulesRegistry registry = InjectedValues.getInstance().getModulesRegistry();
        AdminCommandContextImpl ctx = new AdminCommandContextImpl(AMXLoggerInfo.getLogger(), (ActionReport)new PlainTextActionReporter());
        RestartDomainCommand cmd = new RestartDomainCommand(registry);
        cmd.execute((AdminCommandContext)ctx);
    }

    private NetworkConfig networkConfig() {
        NetworkConfig config = (NetworkConfig)InjectedValues.getInstance().getHabitat().getService(NetworkConfig.class, "default-instance-name", new Annotation[0]);
        return config;
    }

    private NetworkListener getAdminListener() {
        NetworkConfig network = this.networkConfig();
        NetworkListener listener = network.getNetworkListener(ADMIN_LISTENER_NAME);
        return listener;
    }

    private int getRESTPort() {
        return (int)Long.parseLong(this.getAdminListener().getPort());
    }

    private String get_asadmin() {
        Protocol protocol = this.networkConfig().getProtocols().findProtocol(ADMIN_LISTENER_NAME);
        return protocol.getHttp().getDefaultVirtualServer();
    }

    public String getRESTBaseURL() throws MalformedURLException {
        Protocol protocol = this.networkConfig().getProtocols().findProtocol(ADMIN_LISTENER_NAME);
        String scheme = Boolean.parseBoolean(protocol.getSecurityEnabled()) ? "https" : "http";
        String host = "localhost";
        URL url = new URL(scheme, "localhost", this.getRESTPort(), "/" + this.get_asadmin());
        return url.toString() + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeREST(String cmd) {
        String result = null;
        HttpURLConnection conn = null;
        try {
            String url = this.getRESTBaseURL() + cmd;
            URL invoke = new URL(url);
            conn = (HttpURLConnection)invoke.openConnection();
            InputStream is = conn.getInputStream();
            result = RuntimeRootImpl.toString(is);
            is.close();
        }
        catch (Exception e) {
            result = ExceptionUtil.toString(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }

    public String[] getSupportedCipherSuites() {
        try {
            SSLUtils sslUtils = (SSLUtils)this.mHabitat.getService(SSLUtils.class, new Annotation[0]);
            return sslUtils.getSupportedCipherSuites();
        }
        catch (Exception ex) {
            AMXLoggerInfo.getLogger().log(Level.INFO, "NCLS-COM-00048", ex);
            return new String[0];
        }
    }

    public String[] getJMXServiceURLs() {
        try {
            AMXGlassfish amxg = AMXGlassfish.DEFAULT;
            JMXServiceURL[] items = (JMXServiceURL[])this.getMBeanServer().getAttribute(amxg.getBootAMXMBeanObjectName(), "JMXServiceURLs");
            String[] urls = new String[items.length];
            for (int i = 0; i < items.length; ++i) {
                urls[i] = "" + items[i];
            }
            return urls;
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public String getJVMReport(String type) {
        JVMInformation info = new JVMInformation((MBeanServerConnection)this.getMBeanServer());
        String NL = StringUtil.LS;
        String target = "das";
        String result = "FAILED";
        if ("summary".equals(type)) {
            result = info.getSummary("das");
        } else if ("memory".equals(type)) {
            result = info.getMemoryInformation("das");
        } else if ("thread".equals(type)) {
            result = info.getThreadDump("das");
        } else if ("class".equals(type)) {
            result = info.getClassInformation("das");
        } else if ("log".equals(type)) {
            result = info.getLogInformation("das");
        } else if ("all".equals(type)) {
            result = "SUMMARY" + NL + NL + this.getJVMReport("summary") + NL + NL + "MEMORY" + NL + NL + this.getJVMReport("memory") + NL + NL + "THREADS" + NL + NL + this.getJVMReport("thread") + NL + NL + "CLASSES" + NL + NL + this.getJVMReport("class") + NL + NL + "LOGGING" + NL + NL + this.getJVMReport("log");
        } else {
            throw new IllegalArgumentException("Unsupported JVM report type: " + type);
        }
        if (result != null) {
            result = result.replace("%%%EOL%%%", NL);
        }
        return result;
    }

    public boolean isStartedInDebugMode() {
        boolean inDebugMode = false;
        String s = System.getProperty("hk2.startup.context.args");
        if (s != null) {
            String[] ss;
            String prefix = "-debug=";
            for (String opt : ss = s.split("\n")) {
                if (!opt.startsWith("-debug=")) continue;
                String value = opt.substring("-debug=".length()).toLowerCase(Locale.ENGLISH);
                inDebugMode = Boolean.valueOf(value);
                break;
            }
        }
        return inDebugMode;
    }
}

