/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc.ap;

import com.sun.tools.jxc.ap.SecureLoader;
import com.sun.xml.bind.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import com.sun.xml.bind.v2.model.annotation.Locatable;
import com.sun.xml.bind.v2.model.annotation.LocatableAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;

public final class InlineAnnotationReaderImpl
extends AbstractInlineAnnotationReaderImpl<TypeMirror, TypeElement, VariableElement, ExecutableElement> {
    public static final InlineAnnotationReaderImpl theInstance = new InlineAnnotationReaderImpl();

    private InlineAnnotationReaderImpl() {
    }

    @Override
    public <A extends Annotation> A getClassAnnotation(Class<A> a, TypeElement clazz, Locatable srcPos) {
        return LocatableAnnotation.create(clazz.getAnnotation(a), srcPos);
    }

    @Override
    public <A extends Annotation> A getFieldAnnotation(Class<A> a, VariableElement f, Locatable srcPos) {
        return LocatableAnnotation.create(f.getAnnotation(a), srcPos);
    }

    @Override
    public boolean hasFieldAnnotation(Class<? extends Annotation> annotationType, VariableElement f) {
        return f.getAnnotation(annotationType) != null;
    }

    @Override
    public boolean hasClassAnnotation(TypeElement clazz, Class<? extends Annotation> annotationType) {
        return clazz.getAnnotation(annotationType) != null;
    }

    @Override
    public Annotation[] getAllFieldAnnotations(VariableElement field, Locatable srcPos) {
        return this.getAllAnnotations(field, srcPos);
    }

    @Override
    public <A extends Annotation> A getMethodAnnotation(Class<A> a, ExecutableElement method, Locatable srcPos) {
        return LocatableAnnotation.create(method.getAnnotation(a), srcPos);
    }

    @Override
    public boolean hasMethodAnnotation(Class<? extends Annotation> a, ExecutableElement method) {
        return method.getAnnotation(a) != null;
    }

    @Override
    public Annotation[] getAllMethodAnnotations(ExecutableElement method, Locatable srcPos) {
        return this.getAllAnnotations(method, srcPos);
    }

    private Annotation[] getAllAnnotations(Element decl, Locatable srcPos) {
        ArrayList<Annotation> r = new ArrayList<Annotation>();
        for (AnnotationMirror annotationMirror : decl.getAnnotationMirrors()) {
            try {
                String fullName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                Class<Annotation> type = SecureLoader.getClassClassLoader(this.getClass()).loadClass(fullName).asSubclass(Annotation.class);
                Annotation annotation2 = decl.getAnnotation(type);
                if (annotation2 == null) continue;
                r.add(LocatableAnnotation.create(annotation2, srcPos));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return r.toArray(new Annotation[r.size()]);
    }

    @Override
    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> a, ExecutableElement m, int paramIndex, Locatable srcPos) {
        VariableElement[] params = m.getParameters().toArray(new VariableElement[m.getParameters().size()]);
        return LocatableAnnotation.create(params[paramIndex].getAnnotation(a), srcPos);
    }

    @Override
    public <A extends Annotation> A getPackageAnnotation(Class<A> a, TypeElement clazz, Locatable srcPos) {
        return LocatableAnnotation.create(clazz.getEnclosingElement().getAnnotation(a), srcPos);
    }

    @Override
    public TypeMirror getClassValue(Annotation a, String name) {
        try {
            a.annotationType().getMethod(name, new Class[0]).invoke((Object)a, new Object[0]);
            assert (false);
            throw new IllegalStateException("should throw a MirroredTypeException");
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof MirroredTypeException) {
                MirroredTypeException me = (MirroredTypeException)e.getCause();
                return me.getTypeMirror();
            }
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public TypeMirror[] getClassArrayValue(Annotation a, String name) {
        try {
            a.annotationType().getMethod(name, new Class[0]).invoke((Object)a, new Object[0]);
            assert (false);
            throw new IllegalStateException("should throw a MirroredTypesException");
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof MirroredTypesException) {
                MirroredTypesException me = (MirroredTypesException)e.getCause();
                List<? extends TypeMirror> r = me.getTypeMirrors();
                return r.toArray(new TypeMirror[r.size()]);
            }
            if (e.getCause() instanceof MirroredTypeException) {
                MirroredTypeException me = (MirroredTypeException)e.getCause();
                TypeMirror tr = me.getTypeMirror();
                TypeMirror[] trArr = new TypeMirror[]{tr};
                return trArr;
            }
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    @Override
    protected String fullName(ExecutableElement m) {
        return ((TypeElement)m.getEnclosingElement()).getQualifiedName().toString() + '#' + m.getSimpleName();
    }
}

