/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.glassfish.api.naming.NamingClusterInfo;
import org.glassfish.api.naming.NamingObjectsProvider;
import org.glassfish.enterprise.iiop.impl.GroupInfoServiceObserverImpl;
import org.glassfish.enterprise.iiop.impl.RoundRobinPolicy;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;

@Service
@Singleton
public class NamingClusterInfoImpl
implements NamingClusterInfo {
    @LoggerInfo(subsystem="orb", description="logger for GlassFish appserver orb modules", publish=true)
    public static final String ORB_LOGGER_NAME = "org.glassfish.orb";
    @LogMessagesResourceBundle
    public static final String ORB_LOGGER_RB = "org.glassfish.orb.LogMessages";
    public static final Logger logger = Logger.getLogger("org.glassfish.orb", "org.glassfish.orb.LogMessages");
    @LogMessageInfo(message="Exception occurred when resolving {0}", cause="org.omg.CORBA.ORBPackage.InvalidName when trying to resolve GroupInfoService", action="Check server.log for details")
    public static final String FAILED_TO_RESOLVE_GROUPINFOSERVICE = "AS-ORB-00001";
    @LogMessageInfo(message="No Endpoints selected in com.sun.appserv.iiop.endpoints property. Using {0}:{1} instead")
    public static final String NO_ENDPOINT_SELECTED = "AS-ORB-00002";
    private RoundRobinPolicy rrPolicy;
    private GroupInfoServiceObserverImpl giso;

    public void initGroupInfoService(Hashtable<?, ?> myEnv, String defaultHost, String defaultPort, ORB orb, ServiceLocator services) {
        List<String> epList = this.getEndpointList(myEnv, defaultHost, defaultPort);
        this.rrPolicy = new RoundRobinPolicy(epList);
        GroupInfoService gis = null;
        try {
            gis = (GroupInfoService)orb.resolve_initial_references("FolbClientGroupInfoService");
        }
        catch (InvalidName ex) {
            logger.log(Level.SEVERE, FAILED_TO_RESOLVE_GROUPINFOSERVICE, "FolbClientGroupInfoService");
            logger.log(Level.SEVERE, "", ex);
        }
        this.giso = new GroupInfoServiceObserverImpl(gis, this.rrPolicy);
        gis.addObserver((GroupInfoServiceObserver)this.giso);
        if (services != null) {
            for (ServiceHandle provider : services.getAllServiceHandles(NamingObjectsProvider.class, new Annotation[0])) {
                provider.getService();
            }
        }
        this.giso.forceMembershipChange();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "NamingClusterInfoImpl.initGroupInfoService RoundRobinPolicy {0}", this.rrPolicy);
        }
    }

    public void setClusterInstanceInfo(Hashtable<?, ?> myEnv, String defaultHost, String defaultPort, boolean membershipChangeForced) {
        List<String> list = this.getEndpointList(myEnv, defaultHost, defaultPort);
        this.rrPolicy.setClusterInstanceInfoFromString(list);
        if (!membershipChangeForced) {
            this.giso.forceMembershipChange();
        }
    }

    public List<String> getNextRotation() {
        return this.rrPolicy.getNextRotation();
    }

    private List<String> getEndpointList(Hashtable env, String defaultHost, String defaultPort) {
        String first;
        ArrayList<String> list = new ArrayList<String>();
        String lbpv = this.getEnvSysProperty(env, "com.sun.appserv.iiop.loadbalancingpolicy");
        List<String> lbList = this.splitOnComma(lbpv);
        if (lbList.size() > 0 && ((first = lbList.remove(0)).equals("ic-based") || first.equals("ic-based-weighted"))) {
            System.setProperty("com.sun.appserv.iiop.loadbalancingpolicy", first);
        }
        list.addAll(lbList);
        if (list.isEmpty()) {
            String iepv = this.getEnvSysProperty(env, "com.sun.appserv.iiop.endpoints");
            List<String> epList = this.splitOnComma(iepv);
            list.addAll(epList);
        }
        if (list.isEmpty()) {
            String urlValue = (String)env.get("java.naming.provider.url");
            list.addAll(this.rrPolicy.getEndpointForProviderURL(urlValue));
        }
        if (list.isEmpty()) {
            String host = this.getEnvSysProperty(env, "org.omg.CORBA.ORBInitialHost");
            String port = this.getEnvSysProperty(env, "org.omg.CORBA.ORBInitialPort");
            if (host != null && port != null) {
                list.addAll(this.rrPolicy.getAddressPortList(host, port));
                logger.log(Level.WARNING, NO_ENDPOINT_SELECTED, new Object[]{host, port});
            }
        }
        if (list.isEmpty() && defaultHost != null && defaultPort != null) {
            list.add(defaultHost + ":" + defaultPort);
        }
        if (list.isEmpty()) {
            throw new RuntimeException("Cannot Proceed. No Endpoints specified.");
        }
        return list;
    }

    private List<String> splitOnComma(String arg) {
        String[] splits;
        ArrayList<String> result = new ArrayList<String>();
        if (arg != null && (splits = arg.split(",")) != null) {
            for (String str : splits) {
                result.add(str.trim());
            }
        }
        return result;
    }

    private String getEnvSysProperty(Hashtable env, String pname) {
        String value = (String)env.get(pname);
        if (value == null) {
            value = System.getProperty(pname);
        }
        return value;
    }
}

