/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.diagnostics;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class MessageIdCatalog {
    public ArrayList getDiagnosticCausesForMessageId(String messageId, String moduleName) {
        if (moduleName == null || messageId == null) {
            return null;
        }
        ResourceBundle rb = Logger.getLogger(moduleName).getResourceBundle();
        String cause = null;
        ArrayList<String> causes = null;
        if (rb != null) {
            for (int i = 1; i < 5; ++i) {
                try {
                    cause = rb.getString(messageId + ".diag.cause." + i);
                }
                catch (MissingResourceException e) {
                    break;
                }
                if (cause == null) break;
                if (causes == null) {
                    causes = new ArrayList<String>();
                }
                causes.add(cause);
            }
        }
        return causes;
    }

    public ArrayList getDiagnosticChecksForMessageId(String messageId, String moduleName) {
        if (moduleName == null || messageId == null) {
            return null;
        }
        ResourceBundle rb = Logger.getLogger(moduleName).getResourceBundle();
        String check = null;
        ArrayList<String> checks = null;
        if (rb != null) {
            for (int i = 1; i < 5; ++i) {
                try {
                    check = rb.getString(messageId + ".diag.check." + i);
                }
                catch (MissingResourceException e) {
                    break;
                }
                if (check == null) break;
                if (checks == null) {
                    checks = new ArrayList<String>();
                }
                checks.add(check);
            }
        }
        return checks;
    }
}

