/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgihttp;

import com.sun.enterprise.web.WebModule;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.osgihttp.InvocationContextMgr;
import org.glassfish.osgihttp.OSGiServletWrapper;

public class OSGiHttpContextValve
extends ValveBase {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getPackage().getName());

    public int invoke(Request request, Response response) throws IOException, ServletException {
        this.logger.entering("OSGiHttpContextValve", "invoke", new Object[]{request});
        Wrapper wrapper = request.getWrapper();
        if (wrapper instanceof OSGiServletWrapper) {
            OSGiServletWrapper osgiWrapper = (OSGiServletWrapper)wrapper;
            WebModule osgiWebModule = osgiWrapper.getWebModule();
            InvocationContextMgr.getInvocationContext().setWebModule(osgiWebModule);
            request.setContext((Context)osgiWebModule);
            this.resetSessionFindAttr(request);
        }
        return 1;
    }

    private void resetSessionFindAttr(Request request) {
        if (request instanceof org.apache.catalina.connector.Request) {
            ((org.apache.catalina.connector.Request)org.apache.catalina.connector.Request.class.cast(request)).setUnsuccessfulSessionFind(false);
        } else {
            this.logger.logp(Level.FINE, "OSGiHttpContextValve", "resetSessionFindAttr", "request {0} is not of type {1} ", new Object[]{request, org.apache.catalina.connector.Request.class});
        }
    }
}

