/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.LogFacade;
import com.sun.enterprise.glassfish.bootstrap.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarUtil {
    public static final String JAXR_RA_NAME = "jaxr-ra";
    public static final String JDBCDATASOURCE_RA_NAME = "__ds_jdbc_ra";
    public static final String JDBCCONNECTIONPOOLDATASOURCE_RA_NAME = "__cp_jdbc_ra";
    public static final String JDBCXA_RA_NAME = "__xa_jdbc_ra";
    public static final String JDBCDRIVER_RA_NAME = "__dm_jdbc_ra";
    public static final String DEFAULT_JMS_ADAPTER = "jmsra";
    public static final String RAR_EXTENSION = ".rar";
    public static final List<String> systemRarNames = Collections.unmodifiableList(Arrays.asList("jaxr-ra", "__ds_jdbc_ra", "__cp_jdbc_ra", "__xa_jdbc_ra", "__dm_jdbc_ra", "jmsra"));
    private static final Logger logger = LogFacade.BOOTSTRAP_LOGGER;

    private static String getSystemModuleLocation(String installDir, String rarName) {
        return installDir + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + rarName;
    }

    private static boolean systemModuleLocationExists(String installDir, String rarName) {
        return new File(JarUtil.getSystemModuleLocation(installDir, rarName)).exists();
    }

    public static boolean extractRars(String installDir) {
        boolean extracted = true;
        for (String rarName : systemRarNames) {
            extracted &= JarUtil.extractRar(installDir, rarName);
        }
        return extracted;
    }

    public static void setEnv(String installDir) {
        String imqLib = System.getProperty("com.sun.aas.imqLib", JarUtil.getSystemModuleLocation(installDir, DEFAULT_JMS_ADAPTER));
        System.setProperty("com.sun.aas.imqLib", imqLib);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractRar(String installDir, String rarName) {
        if (JarUtil.systemModuleLocationExists(installDir, rarName)) {
            return false;
        }
        InputStream is = JarUtil.class.getClassLoader().getResourceAsStream(rarName + RAR_EXTENSION);
        if (is != null) {
            String fileName = installDir + File.separator + rarName + RAR_EXTENSION;
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(fileName);
                Util.copy(is, os, is.available());
            }
            catch (IOException e) {
                LogFacade.log(logger, Level.WARNING, "NCLS-BOOTSTRAP-00003", e, rarName);
                boolean bl = false;
                return bl;
            }
            finally {
                block25: {
                    block24: {
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException ioe) {
                            if (!logger.isLoggable(Level.FINEST)) break block24;
                            logger.log(Level.FINEST, "Exception while closing archive [ " + fileName + " ]", ioe);
                        }
                    }
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        if (!logger.isLoggable(Level.FINEST)) break block25;
                        logger.log(Level.FINEST, "Exception while closing archive [ " + rarName + " ]", ioe);
                    }
                }
            }
            File file = new File(fileName);
            if (file.exists()) {
                try {
                    JarUtil.extractJar(file, installDir);
                    file.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            logger.log(Level.INFO, "NCLS-BOOTSTRAP-00004", new Object[]{rarName, fileName});
            return false;
        }
        logger.log(Level.FINEST, "could not find RAR [ " + rarName + " ] in the archive, skipping .rar extraction");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractJar(File jarFile, String destDir) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enum1 = jar.entries();
        while (enum1.hasMoreElements()) {
            JarEntry file = enum1.nextElement();
            File f = new File(destDir + File.separator + file.getName());
            if (file.isDirectory()) {
                f.mkdir();
                continue;
            }
            if (f.exists()) continue;
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                is = jar.getInputStream(file);
                fos = new FileOutputStream(f);
                int count = 0;
                byte[] buffer = new byte[8192];
                while ((count = is.read(buffer, 0, buffer.length)) != -1) {
                    fos.write(buffer, 0, count);
                }
            }
            finally {
                block15: {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.FINEST)) break block15;
                        logger.log(Level.FINEST, "exception while closing archive [ " + f.getName() + " ]", e);
                    }
                }
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "exception while closing archive [ " + file.getName() + " ]", e);
                }
            }
        }
    }
}

