/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityContextProxy;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.glassfish.security.common.PrincipalImpl;

public class WebPrincipal
extends PrincipalImpl
implements SecurityContextProxy {
    private char[] password;
    private X509Certificate[] certs;
    private boolean useCertificate;
    private SecurityContext secCtx;
    private Principal customPrincipal;

    public WebPrincipal(Principal p, SecurityContext context) {
        super(p.getName());
        if (!(p instanceof PrincipalImpl)) {
            this.customPrincipal = p;
        }
        this.useCertificate = false;
        this.secCtx = context;
    }

    public WebPrincipal(String user, char[] pwd, SecurityContext context) {
        super(user);
        this.password = pwd == null ? null : Arrays.copyOf(pwd, pwd.length);
        this.useCertificate = false;
        this.secCtx = context;
    }

    @Deprecated
    public WebPrincipal(String user, String password, SecurityContext context) {
        this(user, password.toCharArray(), context);
    }

    public WebPrincipal(X509Certificate[] certs, SecurityContext context) {
        super(certs[0].getSubjectDN().getName());
        this.certs = certs;
        this.useCertificate = true;
        this.secCtx = context;
    }

    public char[] getPassword() {
        char[] passwordCopy = this.password == null ? null : Arrays.copyOf(this.password, this.password.length);
        return passwordCopy;
    }

    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    public boolean isUsingCertificate() {
        return this.useCertificate;
    }

    public SecurityContext getSecurityContext() {
        return this.secCtx;
    }

    public String getName() {
        if (this.customPrincipal == null) {
            return super.getName();
        }
        return this.customPrincipal.getName();
    }

    public boolean equals(Object another) {
        if (this.customPrincipal == null) {
            return super.equals(another);
        }
        return this.customPrincipal.equals(another);
    }

    public int hashCode() {
        if (this.customPrincipal == null) {
            return super.hashCode();
        }
        return this.customPrincipal.hashCode();
    }

    public String toString() {
        if (this.customPrincipal == null) {
            return super.toString();
        }
        return this.customPrincipal.toString();
    }
}

