/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.helper;

import com.sun.jaspic.config.delegate.MessagePolicyDelegate;
import com.sun.jaspic.config.helper.AuthConfigHelper;
import com.sun.jaspic.config.helper.AuthContextHelper;
import com.sun.jaspic.config.helper.EpochCarrier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;

public class ServerAuthConfigHelper
extends AuthConfigHelper
implements ServerAuthConfig {
    static final AuthStatus[] vR_SuccessValue = new AuthStatus[]{AuthStatus.SUCCESS, AuthStatus.SEND_SUCCESS};
    static final AuthStatus[] sR_SuccessValue = new AuthStatus[]{AuthStatus.SEND_SUCCESS};
    HashMap<String, HashMap<Integer, ServerAuthContext>> contextMap;
    AuthContextHelper acHelper;

    protected ServerAuthConfigHelper(String loggerName, EpochCarrier providerEpoch, AuthContextHelper acHelper, MessagePolicyDelegate mpDelegate, String layer, String appContext, CallbackHandler cbh) throws AuthException {
        super(loggerName, providerEpoch, mpDelegate, layer, appContext, cbh);
        this.acHelper = acHelper;
        this.mpDelegate = mpDelegate;
    }

    @Override
    protected void initializeContextMap() {
        this.contextMap = new HashMap();
    }

    protected void refreshContextHelper() {
        this.acHelper.refresh();
    }

    protected ServerAuthContext createAuthContext(final String authContextID, final Map properties) throws AuthException {
        if (!this.acHelper.isProtected(new ServerAuthModule[0], authContextID)) {
            return null;
        }
        return new ServerAuthContext(){
            ServerAuthModule[] module = this.init();

            ServerAuthModule[] init() throws AuthException {
                ServerAuthModule[] m;
                try {
                    m = ServerAuthConfigHelper.this.acHelper.getModules(new ServerAuthModule[0], authContextID);
                }
                catch (AuthException ae) {
                    ServerAuthConfigHelper.this.logIfLevel(Level.SEVERE, ae, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigHelper.this.getAppContext(), "unable to load server auth modules");
                    throw ae;
                }
                MessagePolicy requestPolicy = ServerAuthConfigHelper.this.mpDelegate.getRequestPolicy(authContextID, properties);
                MessagePolicy responsePolicy = ServerAuthConfigHelper.this.mpDelegate.getResponsePolicy(authContextID, properties);
                boolean noModules = true;
                for (int i = 0; i < m.length; ++i) {
                    if (m[i] == null) continue;
                    if (ServerAuthConfigHelper.this.isLoggable(Level.FINE)) {
                        ServerAuthConfigHelper.this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigHelper.this.getAppContext(), "initializing module");
                    }
                    noModules = false;
                    ServerAuthConfigHelper.this.checkMessageTypes(m[i].getSupportedMessageTypes());
                    m[i].initialize(requestPolicy, responsePolicy, ServerAuthConfigHelper.this.cbh, ServerAuthConfigHelper.this.acHelper.getInitProperties(i, properties));
                }
                if (noModules) {
                    ServerAuthConfigHelper.this.logIfLevel(Level.WARNING, null, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigHelper.this.getAppContext(), "contains no Auth Modules");
                }
                return m;
            }

            public AuthStatus validateRequest(MessageInfo arg0, Subject arg1, Subject arg2) throws AuthException {
                AuthStatus[] status = new AuthStatus[this.module.length];
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ServerAuthConfigHelper.this.isLoggable(Level.FINE)) {
                        ServerAuthConfigHelper.this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigHelper.this.getAppContext(), "calling vaidateRequest on module");
                    }
                    status[i] = this.module[i].validateRequest(arg0, arg1, arg2);
                    if (!ServerAuthConfigHelper.this.acHelper.exitContext(vR_SuccessValue, i, status[i])) continue;
                    return ServerAuthConfigHelper.this.acHelper.getReturnStatus(vR_SuccessValue, AuthStatus.SEND_FAILURE, status, i);
                }
                return ServerAuthConfigHelper.this.acHelper.getReturnStatus(vR_SuccessValue, AuthStatus.SEND_FAILURE, status, status.length - 1);
            }

            public AuthStatus secureResponse(MessageInfo arg0, Subject arg1) throws AuthException {
                AuthStatus[] status = new AuthStatus[this.module.length];
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ServerAuthConfigHelper.this.isLoggable(Level.FINE)) {
                        ServerAuthConfigHelper.this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigHelper.this.getAppContext(), "calling secureResponse on module");
                    }
                    status[i] = this.module[i].secureResponse(arg0, arg1);
                    if (!ServerAuthConfigHelper.this.acHelper.exitContext(sR_SuccessValue, i, status[i])) continue;
                    return ServerAuthConfigHelper.this.acHelper.getReturnStatus(sR_SuccessValue, AuthStatus.SEND_FAILURE, status, i);
                }
                return ServerAuthConfigHelper.this.acHelper.getReturnStatus(sR_SuccessValue, AuthStatus.SEND_FAILURE, status, status.length - 1);
            }

            public void cleanSubject(MessageInfo arg0, Subject arg1) throws AuthException {
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ServerAuthConfigHelper.this.isLoggable(Level.FINE)) {
                        ServerAuthConfigHelper.this.logIfLevel(Level.FINE, null, "ServerAuthContext: ", authContextID, "of AppContext: ", ServerAuthConfigHelper.this.getAppContext(), "calling cleanSubject on module");
                    }
                    this.module[i].cleanSubject(arg0, arg1);
                }
            }
        };
    }

    public ServerAuthContext getAuthContext(String authContextID, Subject subject, Map properties) throws AuthException {
        return (ServerAuthContext)super.getContext(this.contextMap, authContextID, subject, properties);
    }

    public boolean isProtected() {
        return !this.acHelper.returnsNullContexts() || this.mpDelegate.isProtected();
    }
}

