/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.valves.ValveBase;

public abstract class RequestFilterValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.RequestFilterValve/1.0";
    protected String allow = null;
    protected Pattern[] allows = new Pattern[0];
    protected Pattern[] denies = new Pattern[0];
    protected String deny = null;

    public String getAllow() {
        return this.allow;
    }

    public void setAllow(String allow) {
        this.allow = allow;
        this.allows = this.precalculate(allow);
    }

    public String getDeny() {
        return this.deny;
    }

    public void setDeny(String deny) {
        this.deny = deny;
        this.denies = this.precalculate(deny);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public abstract int invoke(Request var1, Response var2) throws IOException, ServletException;

    protected Pattern[] precalculate(String list) {
        int comma;
        if (list == null) {
            return new Pattern[0];
        }
        if ((list = list.trim()).length() < 1) {
            return new Pattern[0];
        }
        list = list + ",";
        ArrayList<Pattern> reList = new ArrayList<Pattern>();
        while (list.length() > 0 && (comma = list.indexOf(44)) >= 0) {
            String pattern = list.substring(0, comma).trim();
            try {
                reList.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00515"), pattern);
                IllegalArgumentException iae = new IllegalArgumentException(msg);
                iae.initCause(e);
                throw iae;
            }
            list = list.substring(comma + 1);
        }
        Pattern[] reArray = new Pattern[reList.size()];
        return reList.toArray(reArray);
    }

    protected int process(String property, Request request, Response response) throws IOException, ServletException {
        int i;
        for (i = 0; i < this.denies.length; ++i) {
            if (!this.denies[i].matcher(property).matches()) continue;
            this.handleError(request, response, 403);
            return 2;
        }
        for (i = 0; i < this.allows.length; ++i) {
            if (!this.allows[i].matcher(property).matches()) continue;
            return 1;
        }
        if (this.denies.length > 0 && this.allows.length == 0) {
            return 1;
        }
        this.handleError(request, response, 403);
        return 2;
    }

    private void handleError(Request request, Response response, int statusCode) throws IOException {
        ServletRequest sreq = request.getRequest();
        ServletResponse sres = response.getResponse();
        HttpServletResponse hres = (HttpServletResponse)sres;
        ErrorPage errorPage = null;
        if (this.getContainer() instanceof StandardHost) {
            errorPage = ((StandardHost)this.getContainer()).findErrorPage(statusCode);
        } else if (this.getContainer() instanceof StandardContext) {
            errorPage = ((StandardContext)this.getContainer()).findErrorPage(statusCode);
        }
        if (errorPage != null) {
            try {
                hres.setStatus(statusCode);
                ServletContext servletContext = request.getContext().getServletContext();
                ApplicationDispatcher dispatcher = (ApplicationDispatcher)servletContext.getRequestDispatcher(errorPage.getLocation());
                if (hres.isCommitted()) {
                    dispatcher.include(sreq, sres);
                } else {
                    response.resetBuffer(true);
                    dispatcher.dispatch(sreq, sres, DispatcherType.ERROR);
                    response.setSuspended(false);
                }
                sres.flushBuffer();
            }
            catch (Throwable t) {
                if (log.isLoggable(Level.INFO)) {
                    String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00516"), errorPage.getLocation());
                    log.log(Level.INFO, msg, t);
                }
            }
        } else {
            hres.sendError(statusCode);
        }
    }
}

