/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployapi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.glassfish.deployment.client.AbstractDeploymentFacility;
import org.glassfish.logging.annotation.LogMessageInfo;

public class DeploymentFactoryInstaller {
    private static DeploymentFactoryInstaller dfInstaller = null;
    private final String J2EE_DEPLOYMENT_MANAGER_REPOSITORY = "lib" + File.separator + "deployment";
    private static final String J2EE_DEPLOYMENT_MANAGER = "J2EE-DeploymentFactory-Implementation-Class";
    private static final String J2EE_HOME = "com.sun.enterprise.home";
    public static final Logger deplLogger = AbstractDeploymentFacility.deplLogger;
    @LogMessageInfo(message="Deployment manager load failure.  Unable to find {0}", cause="A deployment manager is not available.", action="Correct the reference to the deployment manager.", level="SEVERE")
    private static final String NO_DEPLOYMENT_MANAGER = "AS-DEPLOYMENT-04018";

    private DeploymentFactoryInstaller() {
    }

    public static DeploymentFactoryInstaller getInstaller() {
        if (dfInstaller == null) {
            DeploymentFactoryInstaller tmpInstaller = new DeploymentFactoryInstaller();
            tmpInstaller.initialize();
            dfInstaller = tmpInstaller;
        }
        return dfInstaller;
    }

    public File[] getListOfDeploymentFactoryFiles() {
        File repository = new File(System.getProperty("com.sun.aas.installRoot") + File.separator + this.J2EE_DEPLOYMENT_MANAGER_REPOSITORY);
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.fine("J2EE Deployment factory repository = " + repository.getAbsolutePath());
        }
        if (!repository.exists()) {
            deplLogger.log(Level.SEVERE, NO_DEPLOYMENT_MANAGER, repository.getAbsolutePath());
            return null;
        }
        return repository.listFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installDeploymentFactory(File installedDM) throws IOException {
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.fine("Installing Deployment factory = " + installedDM.getAbsolutePath());
        }
        Manifest m = null;
        try (JarFile jarFile = new JarFile(installedDM);){
            m = jarFile.getManifest();
        }
        String className = m.getMainAttributes().getValue(J2EE_DEPLOYMENT_MANAGER);
        final URL[] urls = new URL[]{installedDM.toURI().toURL()};
        URLClassLoader urlClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls, this.getClass().getClassLoader());
            }
        });
        Class<?> factory = null;
        try {
            factory = urlClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            deplLogger.log(Level.SEVERE, NO_DEPLOYMENT_MANAGER, className);
            throw new IllegalArgumentException(className + " is not present in the " + installedDM.getName());
        }
        Object df = null;
        try {
            df = factory.newInstance();
        }
        catch (Exception ie) {
            LogRecord lr = new LogRecord(Level.SEVERE, NO_DEPLOYMENT_MANAGER);
            Object[] args = new Object[]{className};
            lr.setParameters(args);
            lr.setThrown(ie);
            deplLogger.log(lr);
            throw new IllegalArgumentException("Cannot install " + installedDM.getName());
        }
        if (!(df instanceof DeploymentFactory)) {
            throw new IllegalArgumentException("The " + className + " declared as a DeploymentFactory does implement the DeploymentFactory interface");
        }
        DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)df);
    }

    protected void initialize() {
        File[] elligibleFiles = this.getListOfDeploymentFactoryFiles();
        if (elligibleFiles == null) {
            return;
        }
        for (int i = 0; i < elligibleFiles.length; ++i) {
            try {
                this.installDeploymentFactory(elligibleFiles[i]);
                continue;
            }
            catch (Exception ioe) {
                LogRecord lr = new LogRecord(Level.SEVERE, NO_DEPLOYMENT_MANAGER);
                Object[] args = new Object[]{elligibleFiles[i].getName()};
                lr.setParameters(args);
                lr.setThrown(ioe);
                deplLogger.log(lr);
            }
        }
    }
}

