/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.utility;

import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class AugmentationTest {
    static boolean debug = false;
    static final PrintStream out = System.out;
    public final int AFFIRMATIVE = 1;
    public final int NEGATIVE = 0;
    public final int ERROR = -1;
    boolean verbose;
    boolean requirePC;
    List classes;
    String className;
    Class classClass;
    private static final String[] transientPrefixes = new String[]{"java.", "javax.", "com.sun.jdo."};

    static final void affirm(boolean cond) {
        if (debug && !cond) {
            throw new RuntimeException("affirmion failed.");
        }
    }

    static final void affirm(Object obj) {
        if (debug && obj == null) {
            throw new RuntimeException("affirmion failed: obj = null");
        }
    }

    static String toString(int mods, Class type, String name) {
        StringBuffer s = new StringBuffer();
        s.append(Modifier.toString(mods));
        s.append(" ");
        s.append(type.getName());
        s.append(" ");
        s.append(name);
        return s.toString();
    }

    static String toString(int mods, String name, Class[] params) {
        StringBuffer s = new StringBuffer();
        s.append(Modifier.toString(mods));
        s.append(" ");
        s.append(name);
        s.append("(");
        int j = params.length - 1;
        for (int i = 0; i <= j; ++i) {
            s.append(params[i].getName());
            if (i >= j) continue;
            s.append(",");
        }
        s.append(")");
        return s.toString();
    }

    static String toString(int mods, Class result, String name, Class[] params) {
        StringBuffer s = new StringBuffer();
        s.append(Modifier.toString(mods));
        s.append(" ");
        s.append(result.getName());
        s.append(" ");
        s.append(name);
        s.append("(");
        int j = params.length - 1;
        for (int i = 0; i <= j; ++i) {
            s.append(params[i].getName());
            if (i >= j) continue;
            s.append(",");
        }
        s.append(")");
        return s.toString();
    }

    final void println() {
        out.println();
    }

    final void println(String msg) {
        out.println(msg);
    }

    final void verbose() {
        if (this.verbose) {
            out.println();
        }
    }

    final void verbose(String msg) {
        if (this.verbose) {
            out.println(msg);
        }
    }

    public int testLoadingClass() {
        this.verbose();
        this.verbose("Test loading class: " + this.className + " ...");
        try {
            this.classClass = Class.forName(this.className);
            this.verbose("+++ loaded class");
            return 1;
        }
        catch (LinkageError err) {
            this.println("!!! ERROR: linkage error when loading class: " + this.className);
            this.println("    error: " + err);
            this.println("!!! failed loading class");
            return -1;
        }
        catch (ClassNotFoundException ex) {
            this.println("!!! ERROR: class not found: " + this.className);
            this.println("    exception: " + ex);
            this.println("!!! failed loading class");
            return -1;
        }
    }

    int implementsInterface(Class intf) {
        Class<?>[] interfaces = this.classClass.getInterfaces();
        for (int i = interfaces.length - 1; i >= 0; --i) {
            if (!interfaces[i].equals(intf)) continue;
            this.verbose("+++ implements interface: " + intf.getName());
            return 1;
        }
        this.verbose("--- not implementing interface: " + intf.getName());
        return 0;
    }

    int hasField(int mods, Class type, String name) {
        try {
            Field field = this.classClass.getField(name);
            if (field.getModifiers() != mods || !field.getType().equals(type)) {
                this.println("!!! ERROR: field declaration: ");
                this.println("    expected: " + AugmentationTest.toString(mods, type, name));
                this.println("    found:    " + field.toString());
                return -1;
            }
            this.verbose("+++ has field: " + field.toString());
            return 1;
        }
        catch (NoSuchFieldException ex) {
            this.verbose("--- no field: " + AugmentationTest.toString(mods, type, name));
            return 0;
        }
    }

    int hasConstructor(int mods, Class[] params) {
        try {
            Constructor ctor = this.classClass.getConstructor(params);
            if (ctor.getModifiers() != mods) {
                this.println("!!! ERROR: constructor declaration: ");
                this.println("    expected: " + AugmentationTest.toString(mods, this.className, params));
                this.println("    found:    " + ctor.toString());
                return -1;
            }
            this.verbose("+++ has constructor: " + ctor.toString());
            return 1;
        }
        catch (NoSuchMethodException ex) {
            this.verbose("--- no constructor: " + AugmentationTest.toString(mods, this.className, params));
            return 0;
        }
    }

    int hasMethod(int mods, Class result, String name, Class[] params) {
        try {
            Method method = this.classClass.getMethod(name, params);
            if (method.getModifiers() != mods || !method.getReturnType().equals(result)) {
                this.println("!!! ERROR: method declaration: ");
                this.println("    expected: " + AugmentationTest.toString(mods, result, name, params));
                this.println("    found:    " + method.toString());
                return -1;
            }
            this.verbose("+++ has method: " + method.toString());
            return 1;
        }
        catch (NoSuchMethodException ex) {
            this.verbose("--- no method: " + AugmentationTest.toString(mods, result, name, params));
            return 0;
        }
    }

    public int hasGenericAugmentation() {
        AugmentationTest.affirm(true);
        this.verbose();
        this.verbose("Check for \"generic\" augmentation ...");
        AugmentationTest.affirm(this.classClass);
        int nofFeatures = 15;
        int[] r = new int[15];
        int i = 0;
        r[i++] = this.implementsInterface(PersistenceCapable.class);
        r[i++] = this.hasField(129, StateManager.class, "jdoStateManager");
        r[i++] = this.hasField(129, Byte.TYPE, "jdoFlags");
        r[i++] = this.hasMethod(17, StateManager.class, "jdoGetStateManager", new Class[0]);
        r[i++] = this.hasMethod(17, Void.TYPE, "jdoSetStateManager", new Class[]{StateManager.class});
        r[i++] = this.hasMethod(17, Byte.TYPE, "jdoGetFlags", new Class[0]);
        r[i++] = this.hasMethod(17, Void.TYPE, "jdoSetFlags", new Class[]{Byte.TYPE});
        r[i++] = this.hasMethod(17, PersistenceManager.class, "jdoGetPersistenceManager", new Class[0]);
        r[i++] = this.hasMethod(17, Object.class, "jdoGetObjectId", new Class[0]);
        r[i++] = this.hasMethod(17, Boolean.TYPE, "jdoIsDirty", new Class[0]);
        r[i++] = this.hasMethod(17, Boolean.TYPE, "jdoIsTransactional", new Class[0]);
        r[i++] = this.hasMethod(17, Boolean.TYPE, "jdoIsPersistent", new Class[0]);
        r[i++] = this.hasMethod(17, Boolean.TYPE, "jdoIsNew", new Class[0]);
        r[i++] = this.hasMethod(17, Boolean.TYPE, "jdoIsDeleted", new Class[0]);
        r[i++] = this.hasMethod(17, Void.TYPE, "jdoMakeDirty", new Class[]{String.class});
        AugmentationTest.affirm(i == 15);
        int res = 0;
        for (int i2 = 0; i2 < 15; ++i2) {
            int j = r[i2];
            AugmentationTest.affirm(-1 <= j && j <= 1);
            if (j < res) {
                this.println("!!! ERROR: inconsistent \"generic\" augmentation of class: " + this.className);
                return -1;
            }
            if (j <= 0) continue;
            res = j;
        }
        if (res > 0) {
            this.verbose("+++ has \"generic\" augmentation");
            return 1;
        }
        this.verbose("--- no \"generic\" augmentation");
        return 0;
    }

    public int hasSpecificAugmentation() {
        AugmentationTest.affirm(true);
        this.verbose();
        this.verbose("Check for \"class-specific\" augmentation ...");
        AugmentationTest.affirm(this.classClass);
        int nofFeatures = 5;
        int[] r = new int[5];
        int i = 0;
        r[i++] = this.hasConstructor(1, new Class[]{StateManager.class});
        r[i++] = this.hasMethod(1, Object.class, "jdoGetField", new Class[]{Integer.TYPE});
        r[i++] = this.hasMethod(1, Void.TYPE, "jdoSetField", new Class[]{Integer.TYPE, Object.class});
        r[i++] = this.hasMethod(1, Void.TYPE, "jdoClear", new Class[0]);
        r[i++] = this.hasMethod(1, Object.class, "jdoNewInstance", new Class[]{StateManager.class});
        AugmentationTest.affirm(i == 5);
        int res = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            int j = r[i2];
            AugmentationTest.affirm(-1 <= j && j <= 1);
            if (j < res) {
                this.println("!!! ERROR: inconsistent \"class-specific\" augmentation of class: " + this.className);
                return -1;
            }
            if (j <= 0) continue;
            res = j;
        }
        if (res > 0) {
            this.verbose("+++ has \"class-specific\" augmentation");
            return 1;
        }
        this.verbose("--- no \"class-specific\" augmentation");
        return 0;
    }

    public int testPCFeasibility() {
        this.verbose();
        this.verbose("Test feasibility of class: " + this.className + " ...");
        int status = 1;
        int mods = this.classClass.getModifiers();
        if (this.classClass.isPrimitive()) {
            this.println("!!! ERROR: specified class is primitive type");
            status = -1;
        }
        if (this.classClass.isArray()) {
            this.println("!!! ERROR: specified class is array");
            status = -1;
        }
        if (this.classClass.isInterface()) {
            this.println("!!! ERROR: specified class is interface");
            status = -1;
        }
        if (Modifier.isAbstract(mods)) {
            this.println("!!! ERROR: specified class is abstract");
            status = -1;
        }
        if (!Modifier.isPublic(mods)) {
            this.println("!!! ERROR: specified class is not public");
            status = -1;
        }
        if (this.classClass.getDeclaringClass() != null) {
            this.println("!!! ERROR: specified class is inner class");
            status = -1;
        }
        if (Throwable.class.isAssignableFrom(this.classClass)) {
            this.println("!!! ERROR: specified class extends Throwable");
            status = -1;
        }
        for (int i = 0; i < transientPrefixes.length; ++i) {
            String typePrefix = transientPrefixes[i];
            if (!this.className.startsWith(typePrefix)) continue;
            this.println("!!! ERROR: specified class starts with package prefix: " + typePrefix);
            status = -1;
        }
        Class superClass = this.classClass.getSuperclass();
        if (superClass == null) {
            this.println("!!! ERROR: specified class doesn't have super class");
            status = -1;
        } else {
            try {
                Class[] params = new Class[]{};
                Constructor constructor = superClass.getConstructor(params);
            }
            catch (NoSuchMethodException ex) {
                this.println("!!! ERROR: super class '" + superClass.getName() + "' doesn't provide default constructor");
                status = -1;
            }
        }
        this.verbose(status == 1 ? "+++ is feasible for persistence-capability" : "!!! not feasible for persistence-capability");
        return status;
    }

    public int testJdoConstructor() {
        this.verbose();
        this.verbose("Test JDO constructor ...");
        AugmentationTest.affirm(this.classClass);
        try {
            Class[] params = new Class[]{StateManager.class};
            Constructor ctor = this.classClass.getConstructor(params);
            Object[] args = new Object[]{null};
            Object instance = ctor.newInstance(args);
            PersistenceCapable pc = (PersistenceCapable)instance;
            if (pc.jdoGetStateManager() != null) {
                this.println("!!! ERROR: invokation of JDO constructor:");
                this.println("    pc.jdoStateManager != null");
                this.println("!!! failed testing JDO constructor");
                return -1;
            }
            if (pc.jdoGetFlags() != 1) {
                this.println("!!! ERROR: invokation of JDO constructor:");
                this.println("    pc.jdoFlags != 0");
                this.println("!!! failed testing JDO constructor");
                return -1;
            }
        }
        catch (NoSuchMethodException ex) {
            this.println("!!! ERROR: no JDO constructor");
            this.println("!!! failed testing JDO constructor");
            return -1;
        }
        catch (InstantiationException ex) {
            this.println("!!! ERROR: invokation of JDO constructor:");
            this.println("    exception: " + ex);
            this.println("!!! failed testing JDO constructor");
            return -1;
        }
        catch (IllegalAccessException ex) {
            this.println("!!! ERROR: invokation of JDO constructor:");
            this.println("    exception: " + ex);
            this.println("!!! failed testing JDO constructor");
            return -1;
        }
        catch (InvocationTargetException ex) {
            this.println("!!! ERROR: invokation of JDO constructor:");
            this.println("    exception: " + ex);
            this.println("    nested:    " + ex.getTargetException());
            this.println("!!! failed testing JDO constructor");
            return -1;
        }
        this.verbose("+++ tested JDO constructor");
        return 1;
    }

    public int test(String className) {
        AugmentationTest.affirm(className);
        this.className = className;
        this.verbose();
        this.verbose("-------------------------------------------------------------------------------");
        this.verbose();
        this.verbose("Test class for augmentation: " + className + " ...");
        if (this.testLoadingClass() < 1) {
            return -1;
        }
        int r0 = this.hasGenericAugmentation();
        int r1 = this.hasSpecificAugmentation();
        if (r1 < 0 || r0 < 0) {
            return -1;
        }
        AugmentationTest.affirm(r1 >= 0 && r0 >= 0);
        if (r1 == 0 && r0 == 0) {
            if (this.requirePC) {
                this.println();
                this.println("!!! ERROR: class not augmented: " + className);
                return -1;
            }
            this.println();
            this.println("--- not augmented: " + className);
            return 0;
        }
        if (r0 == 0) {
            this.println();
            this.println("!!! ERROR: class lacking \"generic\" augmentation: " + className);
            return -1;
        }
        if (r1 == 0) {
            this.println();
            this.println("!!! ERROR: class lacking \"class-specific\" augmentation: " + className);
            return -1;
        }
        AugmentationTest.affirm(r1 > 0 && r0 > 0);
        int r2 = this.testPCFeasibility();
        if (r2 < 1) {
            return -1;
        }
        int r3 = this.testJdoConstructor();
        if (r3 < 1) {
            return -1;
        }
        this.println();
        this.println("+++ augmented: " + className);
        return 1;
    }

    public int test(boolean verbose, boolean requirePC, List classes) {
        AugmentationTest.affirm(classes);
        this.verbose = verbose;
        this.requirePC = requirePC;
        int all = classes.size();
        this.println();
        this.println("AugmentationTest: Testing classes for being enhanced for persistence-capability");
        int failed = 0;
        for (int i = 0; i < all; ++i) {
            if (this.test((String)classes.get(i)) >= 0) continue;
            ++failed;
        }
        int passed = all - failed;
        this.println();
        this.println("AugmentationTest: Summary:  TESTED: " + all + "  PASSED: " + passed + "  FAILED: " + failed);
        return failed;
    }

    static void usage() {
        out.println();
        out.println("Usage: AugmentationTest <options> <classes>...");
        out.println();
        out.println("This class tests if classes have been correctly enhanced");
        out.println("for persistence-capability (\"augmented\").");
        out.println();
        out.println("Options include:");
        out.println("    -h, --help        print usage");
        out.println("    -v, --verbose     enable verbose output");
        out.println("    -pc, --requirePC  require all classes to be augmented");
        out.println();
        out.println("A non-zero value is returned in case of any errors.");
        out.println();
    }

    public static void main(String[] argv) {
        int i;
        boolean verbose = false;
        boolean requirePC = false;
        ArrayList<String> classes = new ArrayList<String>();
        for (i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                AugmentationTest.usage();
                return;
            }
            if (arg.equals("-v") || arg.equals("--verbose")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-pc") || arg.equals("--requirePC")) {
                requirePC = true;
                continue;
            }
            if (arg.equals("--debug")) {
                debug = true;
                continue;
            }
            if (arg.startsWith("-")) {
                out.println();
                out.println("Unrecognized option: " + arg);
                AugmentationTest.usage();
                return;
            }
            classes.add(arg);
        }
        if (classes.isEmpty()) {
            out.println();
            out.println("Missing classes argument");
            AugmentationTest.usage();
            return;
        }
        if (debug) {
            out.println("options:");
            out.println("    verbose = " + verbose);
            out.println("    requirePC = " + requirePC);
            out.print("    classes =");
            for (i = 0; i < classes.size(); ++i) {
                out.print(" " + classes.get(i));
            }
            out.println();
        }
        AugmentationTest test = new AugmentationTest();
        int r = test.test(verbose, requirePC, classes);
        System.exit(r);
    }
}

